/*
 * Decompiled with CFR 0.152.
 */
package dk.predict.buckets;

import dk.Enemy;
import dk.Histogram;
import dk.Util;
import dk.predict.Buckets;
import dk.predict.Factors;
import java.io.PrintStream;
import java.util.List;

public class BucketsVelocity
extends Buckets {
    protected double maxVelocity = 8.0;
    protected int numberOfBuckets_;
    protected Histogram[] buckets_;

    public BucketsVelocity(Enemy enemy, List predictorFactories) {
        this(enemy, predictorFactories, 5);
    }

    public BucketsVelocity(Enemy enemy, List predictorFactories, int numberOfBuckets) {
        super(enemy, predictorFactories);
        this.numberOfBuckets_ = numberOfBuckets;
        this.setupBuckets(predictorFactories);
    }

    public static Buckets.Factory factory() {
        return new Buckets.Factory(){

            public Buckets newInstance(Enemy enemy, List predictorFactories) {
                return new BucketsVelocity(enemy, predictorFactories);
            }
        };
    }

    protected void setupBuckets(List predictorFactories) {
        this.buckets_ = new Histogram[this.numberOfBuckets_];
        int i = 0;
        while (i < this.numberOfBuckets_) {
            this.buckets_[i] = this.createHistogram(predictorFactories);
            this.buckets_[i].setName("bucket < " + Util.valueFromIndex(i, this.numberOfBuckets_, -this.maxVelocity, this.maxVelocity));
            ++i;
        }
    }

    public Histogram getHistogram(Factors f) {
        int index = Util.indexFromValue(f.getVelocity(), this.numberOfBuckets_, -this.maxVelocity, this.maxVelocity);
        return this.buckets_[index];
    }

    public void printStats(PrintStream out) {
        super.printStats(out);
        int i = 0;
        while (i < this.numberOfBuckets_) {
            this.buckets_[i].printStats(out);
            ++i;
        }
    }
}

