/*
 * Decompiled with CFR 0.152.
 */
package kano.gamma;

import java.util.Vector;
import kano.gamma.IStrategy;
import kano.gamma.KanoGamma;
import kano.gamma.Point;
import kano.gamma.Zone;

public class MeleeStrategy
implements IStrategy {
    KanoGamma bot;
    Vector cornerZones = null;
    Vector cuadrantZones = null;
    Vector sideZones = null;
    Vector pathZones = null;
    Point coord = new Point(0.0, 0.0);

    public MeleeStrategy(KanoGamma bot) {
        this.bot = bot;
    }

    public void run() {
        this.bot.scanMgr.scan();
        this.bot.enemyMgr.selectNearestTarget();
        this.coord.setPoint(this.bot.getX(), this.bot.getY());
        if (!this.bot.isInCorner()) {
            Vector zones = this.getCornerZones();
            this.bot.enemyMgr.calculateZonesStatistics(zones);
            Zone zone = this.getBestCornerZone(zones);
            if (zone != null) {
                this.bot.moveMgr.manualMove(zone.p2.x, zone.p2.y);
            } else {
                zones = this.getSideZones();
                this.bot.enemyMgr.calculateZonesStatistics(zones);
                zone = this.getBestSideZone(zones);
                if (zone != null) {
                    if (zone.ratio > 10000.0) {
                        this.bot.moveMgr.manualMove(zone.pMid.x, zone.pMid.y);
                    } else {
                        this.bot.moveMgr.normalMove();
                    }
                } else {
                    zones = this.getCuadrantZones();
                    this.bot.enemyMgr.calculateZonesStatistics(zones);
                    zone = this.getBestCuadrantZone(zones);
                    if (!zone.isInZone(this.bot.getX(), this.bot.getY())) {
                        zones = this.getPathZones(zone.pMid);
                        this.bot.enemyMgr.calculateZonesStatistics(zones);
                        zone = this.getBestSideZone(zones);
                        if (zone != null) {
                            this.bot.moveMgr.manualMove(zone.p1.x, zone.p1.y);
                        } else {
                            this.bot.moveMgr.normalMove();
                        }
                    } else {
                        this.bot.moveMgr.normalMove();
                    }
                }
            }
        } else {
            this.bot.moveMgr.normalMove();
        }
        this.bot.fireMgr.fire();
    }

    public int getPoints() {
        if (this.bot.getOthers() > 1) {
            return 500;
        }
        return 0;
    }

    public Vector getCornerZones() {
        if (this.cornerZones == null) {
            this.cornerZones = new Vector();
            Point sw = new Point(0.0, 0.0);
            Zone zone = new Zone(this.coord, sw);
            this.cornerZones.addElement(zone);
            Point se = new Point(this.bot.getBattleFieldWidth(), 0.0);
            zone = new Zone(this.coord, se);
            this.cornerZones.addElement(zone);
            Point nw = new Point(0.0, this.bot.getBattleFieldHeight());
            zone = new Zone(this.coord, nw);
            this.cornerZones.addElement(zone);
            Point ne = new Point(this.bot.getBattleFieldWidth(), this.bot.getBattleFieldHeight());
            zone = new Zone(this.coord, ne);
            this.cornerZones.addElement(zone);
        }
        this.updateZones(this.cornerZones);
        return this.cornerZones;
    }

    public void updateZones(Vector zones) {
        int l = zones.size();
        int i = 0;
        while (i < l) {
            ((Zone)zones.elementAt(i)).update();
            ++i;
        }
    }

    public Zone getBestCornerZone(Vector zones) {
        int l = zones.size();
        Zone z = null;
        int i = 0;
        while (i < l) {
            Zone z2 = (Zone)zones.elementAt(i);
            if (z2.bots.size() == 0) {
                if (z == null) {
                    z = z2;
                } else if (z2.ratio < z.ratio) {
                    z = z2;
                }
            }
            ++i;
        }
        return z;
    }

    public Vector getCuadrantZones() {
        if (this.cuadrantZones == null) {
            this.cuadrantZones = new Vector();
            Point center = new Point(this.bot.getBattleFieldWidth() / 2.0, this.bot.getBattleFieldHeight() / 2.0);
            Point sw = new Point(0.0, 0.0);
            Zone zone = new Zone(center, sw);
            this.cuadrantZones.addElement(zone);
            Point se = new Point(this.bot.getBattleFieldWidth(), 0.0);
            zone = new Zone(center, se);
            this.cuadrantZones.addElement(zone);
            Point nw = new Point(0.0, this.bot.getBattleFieldHeight());
            zone = new Zone(center, nw);
            this.cuadrantZones.addElement(zone);
            Point ne = new Point(this.bot.getBattleFieldWidth(), this.bot.getBattleFieldHeight());
            zone = new Zone(center, ne);
            this.cuadrantZones.addElement(zone);
        }
        this.updateZones(this.cuadrantZones);
        return this.cuadrantZones;
    }

    public Zone getBestCuadrantZone(Vector zones) {
        Zone z = (Zone)zones.elementAt(0);
        int l = zones.size();
        int i = 1;
        while (i < l) {
            Zone z2 = (Zone)zones.elementAt(i);
            if (z2.bots.size() < z.bots.size()) {
                z = z2;
            } else if (z2.bots.size() == z.bots.size() && z2.energy < z.energy) {
                z = z2;
            }
            ++i;
        }
        return z;
    }

    public Vector getPathZones(Point p) {
        this.pathZones = new Vector();
        Zone z = new Zone(this.coord, p);
        this.pathZones.addElement(z);
        this.updateZones(this.pathZones);
        return this.pathZones;
    }

    public Vector getSideZones() {
        double delta = 200.0;
        if (this.sideZones == null) {
            this.sideZones = new Vector();
            this.sideZones.addElement(new Zone(new Point(0.0, this.bot.getBattleFieldHeight() / 2.0), this.coord));
            this.sideZones.addElement(new Zone(new Point(this.bot.getBattleFieldWidth() / 2.0, 0.0), this.coord));
            this.sideZones.addElement(new Zone(new Point(this.bot.getBattleFieldWidth(), this.bot.getBattleFieldHeight() / 2.0), this.coord));
            this.sideZones.addElement(new Zone(new Point(this.bot.getBattleFieldWidth() / 2.0, this.bot.getBattleFieldHeight()), this.coord));
        }
        this.updateZones(this.sideZones);
        return this.sideZones;
    }

    public Zone getBestSideZone(Vector zones) {
        int l = zones.size();
        Zone z = null;
        int i = 0;
        while (i < l) {
            Zone z2 = (Zone)zones.elementAt(i);
            if (z2.bots.size() == 0) {
                if (z == null) {
                    z = z2;
                } else if (z2.ratio < z.ratio) {
                    z = z2;
                }
            }
            ++i;
        }
        return z;
    }
}

