/*
 * Decompiled with CFR 0.152.
 */
package pulsar;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class PulsarNano
extends AdvancedRobot {
    static double distanceRelation;
    static double flightTimeRelation;
    static int moveTimer;
    static int movingForwardHits;
    static int lastDirectionChange;
    static int direction;

    public void run() {
        this.turnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        direction = -direction;
        lastDirectionChange = -15;
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        double d = scannedRobotEvent.getBearingRadians();
        double d2 = this.getHeadingRadians() + d;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(d2 - this.getGunHeadingRadians())) + scannedRobotEvent.getVelocity() / 13.0 * Math.sin(scannedRobotEvent.getHeadingRadians() - d2));
        this.setFire(this.getEnergy() / 6.0);
        if (lastDirectionChange++ > moveTimer && movingForwardHits > 5) {
            lastDirectionChange = 0;
            moveTimer = (int)(flightTimeRelation / 1.25);
            direction = -direction;
        }
        distanceRelation = scannedRobotEvent.getDistance();
        d2 = Utils.normalRelativeAngle((double)(d - (double)(lastDirectionChange < 0 ? 207 : 310) / distanceRelation * (double)direction));
        d = Double.POSITIVE_INFINITY;
        if (Math.abs(d2) > 1.5707963267948966) {
            d2 = Utils.normalRelativeAngle((double)(d2 + Math.PI));
            d = -d;
        }
        this.setAhead(d);
        this.setTurnRightRadians(d2);
        this.setTurnRadarLeft(this.getRadarTurnRemainingRadians());
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        double d;
        flightTimeRelation = distanceRelation / hitByBulletEvent.getVelocity();
        if ((double)lastDirectionChange > d) {
            ++movingForwardHits;
        }
    }

    static {
        direction = 1;
    }
}

