/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.WeightUpdater;
import dmonner.xlbp.connection.Connection;
import java.util.Arrays;

public class BatchWeightUpdater
implements WeightUpdater {
    public static final long serialVersionUID = 1L;
    private final float a;
    private final Connection parent;
    private float[][] wc;
    private int to;
    private int from;

    public BatchWeightUpdater(Connection parent, float a) {
        this.parent = parent;
        this.a = a;
    }

    @Override
    public Connection getConnection() {
        return this.parent;
    }

    @Override
    public float getUpdate(int i, float dw) {
        return 0.0f;
    }

    @Override
    public float getUpdate(int j, int i, float dw) {
        return 0.0f;
    }

    @Override
    public void initialize(int size) {
        this.initialize(1, size);
    }

    @Override
    public void initialize(int to, int from) {
        this.to = to;
        this.from = from;
        this.wc = new float[to][from];
    }

    @Override
    public void processBatch() {
        int j;
        for (j = 0; j < this.to; ++j) {
            float[] wcj = this.wc[j];
            for (int i = 0; i < this.from; ++i) {
                wcj[i] = wcj[i] * this.a;
            }
        }
        this.parent.updateWeights(this.wc);
        for (j = 0; j < this.wc.length; ++j) {
            Arrays.fill(this.wc[j], 0.0f);
        }
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showLearningRates()) {
            sb.appendln("Learning Rate:" + this.a);
        }
    }

    @Override
    public void updateFromBiases(float[] d) {
        float[] wcj = this.wc[0];
        for (int i = 0; i < this.from; ++i) {
            int n = i;
            wcj[n] = wcj[n] + d[i];
        }
    }

    @Override
    public void updateFromEligibilities(float[][] e, float[] d) {
        for (int j = 0; j < this.to; ++j) {
            float[] ej = e[j];
            float dj = d[j];
            float[] wcj = this.wc[j];
            for (int i = 0; i < this.from; ++i) {
                int n = i;
                wcj[n] = wcj[n] + ej[i] * dj;
            }
        }
    }

    @Override
    public void updateFromInputs(float[] in, float[] d) {
        for (int j = 0; j < this.to; ++j) {
            float dj = d[j];
            float[] wcj = this.wc[j];
            for (int i = 0; i < this.from; ++i) {
                int n = i;
                wcj[n] = wcj[n] + in[i] * dj;
            }
        }
    }

    @Override
    public void updateFromVector(float[] v, float[] d) {
        float[] wcj = this.wc[0];
        for (int i = 0; i < this.from; ++i) {
            int n = i;
            wcj[n] = wcj[n] + v[i] * d[i];
        }
    }
}

