/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import java.io.FileWriter;
import java.io.IOException;

public class CSVWriter
extends FileWriter {
    private final String fieldSep;
    private final String recordSep;
    private final String quote;
    private final String escape;
    private boolean beginningOfRecord;

    public CSVWriter(String filename) throws IOException {
        this(filename, false, ",", "\n", "\"");
    }

    public CSVWriter(String filename, boolean append) throws IOException {
        this(filename, append, ",", "\n", "\"");
    }

    public CSVWriter(String filename, boolean append, String fieldSep, String recordSep, String quote) throws IOException {
        super(filename, append);
        this.fieldSep = fieldSep;
        this.recordSep = recordSep;
        this.quote = quote;
        this.escape = "\\\\";
        this.beginningOfRecord = true;
    }

    public void appendField(boolean field) throws IOException {
        this.sep();
        this.append(String.valueOf(field));
    }

    public void appendField(float field) throws IOException {
        this.sep();
        this.append(String.valueOf(field));
    }

    public void appendField(int field) throws IOException {
        this.sep();
        this.append(String.valueOf(field));
    }

    public void appendField(Object field) throws IOException {
        this.sep();
        if (field == null) {
            this.append("null");
        } else {
            this.append(this.quote);
            this.append(this.clean(field.toString()));
            this.append(this.quote);
        }
    }

    public void appendFields(float[] fields) throws IOException {
        if (fields.length > 0) {
            this.sep();
            this.append(String.valueOf(fields[0]));
        }
        for (int i = 1; i < fields.length; ++i) {
            this.append(this.fieldSep);
            this.append(String.valueOf(fields[i]));
        }
    }

    public void appendFields(Object[] fields) throws IOException {
        if (fields.length > 0) {
            this.sep();
            if (fields[0] instanceof String) {
                this.append(this.quote);
                this.append(this.clean((String)fields[0]));
                this.append(this.quote);
            } else {
                this.append(String.valueOf(fields[0]));
            }
        }
        for (int i = 1; i < fields.length; ++i) {
            if (fields[i] instanceof String) {
                this.append(this.fieldSep);
                this.append(this.quote);
                this.append(this.clean((String)fields[i]));
                this.append(this.quote);
                continue;
            }
            this.append(this.fieldSep);
            this.append(String.valueOf(fields[i]));
        }
    }

    public void appendHeader(String header) throws IOException {
        this.sep();
        this.append(this.quote);
        this.append(this.clean(header));
        this.append(this.quote);
    }

    public void appendHeaders(String[] headers) throws IOException {
        if (headers.length > 0) {
            this.sep();
            this.append(this.quote);
            this.append(this.clean(headers[0]));
            this.append(this.quote);
        }
        for (int i = 1; i < headers.length; ++i) {
            this.append(this.fieldSep);
            this.append(this.quote);
            this.append(this.clean(headers[i]));
            this.append(this.quote);
        }
    }

    public void beginRecord() throws IOException {
        this.endRecord();
    }

    private String clean(String s) {
        if (this.quote.isEmpty()) {
            return s.replaceAll(this.escape, this.escape + this.escape);
        }
        return s.replaceAll(this.escape, this.escape + this.escape).replaceAll(this.quote, this.escape + this.quote);
    }

    @Override
    public void close() throws IOException {
        this.endRecord();
        super.close();
    }

    public void endRecord() throws IOException {
        if (!this.beginningOfRecord) {
            this.append(this.recordSep);
            this.flush();
            this.beginningOfRecord = true;
        }
    }

    private void sep() throws IOException {
        if (this.beginningOfRecord) {
            this.beginningOfRecord = false;
        } else {
            this.append(this.fieldSep);
        }
    }
}

