package pi.radar;

import java.util.*;
import robocode.*;
import pi.*;
public class Radar
{
double p=Math.PI;
MasterBot monRobot;
Vector informations;
double etat;
int compteur=0;

public Radar(MasterBot _monRobot,Vector _informations,double _etat)
	{
	monRobot=_monRobot;
	informations=_informations;	
	etat=_etat;
	}
	
public void RadarinformationsUpdate(ScannedRobotEvent e)
	{
	int comp=0;
	Point mes_coordonnes=new Point(monRobot.getX(),monRobot.getY());
	String nom=e.getName();
	double distance=e.getDistance();
	double energy=e.getEnergy();
	double time=e.getTime();
	double angle_absolu=conversion_en_angle_absolu(e.getBearingRadians());
	Point positionEnnemi=Point.coordonnees_actuelle_absolues_ennemi(mes_coordonnes,distance,angle_absolu);
	
	if(informations==null)
		{
		informations.addElement(new Informations(nom,positionEnnemi,distance,energy,time));
		}
		
	else
		{
		for(int i=0;i<informations.size();i++) /*actualisation*/
			{
			if( ((Informations)informations.elementAt(i)).name==nom ) 							
				{
				informations.setElementAt(new Informations(nom,positionEnnemi,distance,energy,time),i);	
				comp=1;
				}							
			}			
		if(comp==0)	informations.addElement(new Informations(nom,positionEnnemi,distance,energy,time)); /*ajout d'un ennemi*/			
		}
	}
	
public void RadarEnnemiDeathUpdate(RobotDeathEvent e)
	{
	for(int i=0;i<informations.size();i++) /*actualisation*/
		{
		if( ((Informations)informations.elementAt(i)).name==e.getName() ) 							
		informations.removeElementAt(i);									
		}
		
	}
public double plusAncienUpdate()
	{
	double actuel=monRobot.getTime();
	double t=0;
	double temp;
	if(informations!=null )
		{
		for(int i=0;i<informations.size();i++)
			{
			temp=actuel-((Informations)informations.elementAt(i)).time;
			if(temp>t)
				{
				t=temp;	
				}
			}
		return t;	
		}
	else return 10;	
	}
	
			
public RadarMode  selectionMode()
	{
	if(plusAncienUpdate()>8) return new TourHorizon(monRobot,informations);
	else 
		{
		if(etat==1)
			{
			etat=-1;
			return new Sweep(monRobot,informations,1);	
			}
		else
			{
			etat=1;
			return new Sweep(monRobot,informations,-1);		
			}
		}
	}
	
public void UseRadar()
	{
	RadarMode current=selectionMode();	
	current.doRadar();	
	}	
		
public double conversion_en_angle_absolu(double angle_robot_bearing_ennemi)
		{
		double dir_abs_robot=monRobot.getHeadingRadians();
		if(angle_robot_bearing_ennemi+dir_abs_robot<2*p) return dir_abs_robot+angle_robot_bearing_ennemi;
		else return dir_abs_robot+angle_robot_bearing_ennemi-2*p;
		}				
		
		
}
					
					