/*
 * Created on 06/09/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.silversurfer;

import java.text.DecimalFormat;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeScoreReg {

    private String botName;
    private int bots= 0;
    private double damage= 0;
    private double score= 0;
    private double rounds= 0;

    public AxeScoreReg(String bot, int qtd) {
        super();
        botName= bot;
        bots= qtd;
    }

    public AxeScoreReg(
        String bot,
        String qtd,
        String rnds,
        String scr,
        String dmg)
        throws NumberFormatException {
        super();
        botName= bot;
        bots= Integer.parseInt(qtd);
        rounds= Double.parseDouble(rnds);
        score= Double.parseDouble(scr);
        damage= Double.parseDouble(dmg);
    }

    public double getAvgDamage() {
        if (rounds == 0) {
            return 0;
        } else {
            return damage / rounds;
        }
    }

    public double getAvgScore() {
        if (rounds == 0) {
            return 0;
        } else {
            return score / rounds;
        }
    }

    public void incRounds() {
        rounds++;
    }

    public void addScore(double s) {
        score += s;
    }

    public void addDamage(double d) {
        damage += d;
    }

    /**
     * @return
     */
    public int getBots() {
        return bots;
    }

    /**
     * @return
     */
    public double getDamage() {
        return damage;
    }

    /**
     * @return
     */
    public double getRounds() {
        return rounds;
    }

    /**
     * @return
     */
    public double getScore() {
        return score;
    }

    /**
     * @param i
     */
    public void setBots(int i) {
        bots= i;
    }

    /**
     * @param d
     */
    public void setDamage(double d) {
        damage= d;
    }

    /**
     * @param i
     */
    public void setRounds(double i) {
        rounds= i;
    }

    /**
     * @param i
     */
    public void setScore(double i) {
        score= i;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (obj instanceof AxeScoreReg) {
            AxeScoreReg him= (AxeScoreReg)obj;
            if (him.getBotName().equals(this.getBotName())) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    } /* (non-Javadoc)
        * @see java.lang.Object#hashCode()
        */
    public int hashCode() {
        return botName.hashCode();
    } /* (non-Javadoc)
        * @see java.lang.Object#toString()
        */
    public String toString() {
        DecimalFormat forma= new DecimalFormat("0.##");
        return botName
            + " TotBots:"
            + bots
            + " Rounds:"
            + rounds
            + " Score:"
            + (int)score
            + "("
            + forma.format(this.getAvgScore())
            + ")"
            + " Damage:"
            + forma.format(damage)
            + "("
            + forma.format(this.getAvgDamage())
            + ")";
    } /**
            * @return
            */
    public String getBotName() {
        return botName;
    }

}
