package jk.mini;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's
import java.lang.*;         // for Double and Integer objects
import java.util.ArrayList; // for collection of waves
import java.awt.*;
import java.util.*;

public class CunobelinDC extends AdvancedRobot {
 
   static final int GUN_BINS = 255;// full 360 degrees of bins - not just in the reachable range
   static final int MAX_MATCHES = 50;  
	
   static ArrayList hitScans = new ArrayList();
   
   public static Point2D.Double myLocation;    
   public static Point2D.Double enemyLocation; 

   public static ArrayList enemyWaves;
   public static ArrayList pastWaves;
   public static EnemyWaveDC _surfWave;

   public static double enemyEnergy = 100.0;

   public static final Rectangle2D.Double fieldRect
     = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564);
   public static final double WALL_STICK = 160;
   
	
   static StringBuilder data = new StringBuilder();
      
   static double lastLatVel;
   //static int hitCounter;

   //public void run() {
   public CunobelinDC(){
    
   	//NOT NECESSARY FOR 35 ROUND BATTLES - CAN BE REMOVED FOR 15 EXTRA CODESIZE
     //  try{
   //             data.delete(60000, 80000);
   //          }
   //              catch(Exception e){}
   
    
      enemyWaves = new ArrayList();
      pastWaves = new ArrayList();
   
              	
   	
   }
   public void onStatus(StatusEvent e){
      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);
   
      setTurnRadarRightRadians(1);
   }

   public void onScannedRobot(ScannedRobotEvent e) {
      
      int tempIndex;
      double latVel;
   
   
      EnemyWaveDC ew;
      
      double absBearing;
      latVel = (getVelocity()*Math.sin(absBearing = e.getBearingRadians()));
      double advVel = (getVelocity()*Math.cos(absBearing));
   	
      setTurnRadarRightRadians(Utils.normalRelativeAngle((absBearing += getHeadingRadians()) - getRadarHeadingRadians()) * 2);
     
      myLocation = new Point2D.Double(getX(), getY());
      (ew = new EnemyWaveDC()).direction = (int)Math.signum(latVel + 1E-10);
      ew.directAngle = absBearing;
   
      double eDistance;
      ew.scan = new double[]
         {0,(eDistance = e.getDistance())*(1/1000.0),advVel/2,lastLatVel/2, lastLatVel = Math.abs(latVel)};
         
      pastWaves.add(0,ew);
    
      addWave(enemyEnergy - (enemyEnergy = e.getEnergy()));
   
     // update after EnemyWave detection, because that needs the previous
     // enemy location as the source of the wave
      
      enemyLocation = project(myLocation, absBearing, eDistance);
   
      updateWaves();
      //latVel is now direction
      tempIndex = (int)Math.signum(checkDanger(-1) + 1e-20 - checkDanger(1));
      
      //latVel is now goAngle
      latVel = wallSmoothing(myLocation, 
            absBearing + (tempIndex*2),
            tempIndex)
            - getHeadingRadians();
      
      setAhead(Math.cos(latVel)*Double.POSITIVE_INFINITY);
      setTurnRightRadians(Math.tan(latVel));
   
   // GUN \/  \/
      // data.insert(0,(char)(((int)Math.round(e.getVelocity()*Math.sin(latVel = e.getHeadingRadians()- absBearing))<<8)|
         // (0XFF&((byte)(e.getVelocity()*Math.cos(latVel))))));
        
      data.insert(0,(char)(
         //latVel is now enemyOffset
         (4+(Math.round((float)(e.getVelocity()*Math.cos(latVel = e.getHeadingRadians()- absBearing))/2f)))//advancing velocity segment
         |
         //latVel is now enemyLatVel
         ((int)Math.round(latVel = e.getVelocity()*Math.sin(latVel))<<11)//lateral velocity segment
          |
          0x10*(int)Math.signum(fieldRect.outcode(project(myLocation,absBearing+0.57*Math.signum(latVel),eDistance)))//forward wall segment
         //|
         //((int)(eDistance/300)<<6)
         ));
      
      double bulletPower;
      setFire(bulletPower = (int)(150/eDistance) + Math.min(2,Math.min(getEnergy()/16, enemyEnergy/4)));
      
      int[] index ;
      
      int[] bins ; 
      int keyLength = Math.min(66,data.length());
   
            
      index = new int[MAX_MATCHES];
      tempIndex = 0;
      bins = new int[GUN_BINS]; 
      search:
      try{
         do{
            do{
               if( tempIndex < 0 )
                  keyLength/=2;
            
               if(keyLength <= index[0] )
                  break search;
            
               tempIndex = data.indexOf(
                  data.substring(0, keyLength),tempIndex + 2);
            
            }while(tempIndex * Arrays.binarySearch(index,tempIndex) >= 0);
         
            int iterateIndex = index[0] = tempIndex;
            Arrays.sort(index);
            //latVel is now predicted angle offset
            double db = latVel = 0;
            //advVel is now predicted distance
            advVel = eDistance;
         
            rebuild:
            try{
               do
               {
                  char comboChar = data.charAt(iterateIndex--);
               
                  latVel += ((short)comboChar>>11)/
                     (advVel += ((int)(comboChar&0X0F) - 4)<<1); 
                  if(!fieldRect.contains(project(myLocation,absBearing+latVel,advVel)))
                     break rebuild;
               }while ((db+=Rules.getBulletSpeed(bulletPower)) < advVel ); 
            
              
               bins[(int)(Utils.normalAbsoluteAngle(latVel)*((GUN_BINS - 1)/(2*Math.PI)))] += keyLength;
            }
            catch(Exception ex){}
         
         
         }while(true);
      }
      catch(Exception ex){}
   
   
      keyLength = 0;
      tempIndex = 0;
      try{
         while(true){
            if(bins[++keyLength] > bins[tempIndex])
               tempIndex = keyLength;
         }
      
      }
      catch(Exception ex){}
   
      setTurnGunRightRadians(Utils.normalRelativeAngle(
         absBearing 
         + 0.5*(2*Math.PI/(GUN_BINS - 1))
         + tempIndex*(2*Math.PI/(GUN_BINS - 1))
          - getGunHeadingRadians()));
      
   	// gun /\  /\
   
   }

     	
   public static void addWave(double deltaEnergy){
   
      if (pastWaves.size() > 2 && 
      //deltaEnergy <= 3 && deltaEnergy > 0.009
      (char) (deltaEnergy - 1.09999999999) <= 1
      ){
         EnemyWaveDC ew = (EnemyWaveDC)pastWaves.get(2);
         ew.bulletVelocity = Rules.getBulletSpeed(deltaEnergy);
         // ew.distanceTraveled = ew.bulletVelocity;
         ew.fireLocation = enemyLocation;
         enemyWaves.add(ew);
      }
   }
   public static void updateWaves() {
      EnemyWaveDC ew;
      double dist;
      Iterator it = enemyWaves.iterator();
     //register variables
     
      double minDist = Double.NEGATIVE_INFINITY;
      _surfWave = null;
      
      while(it.hasNext()) {
         
         
         if ((dist = ((ew = (EnemyWaveDC)it.next()).distanceTraveled += ew.bulletVelocity )
         - myLocation.distance(ew.fireLocation)) > 50) {
            it.remove();
            continue;
         }
         
         if(dist > minDist 
         && dist < -18){
            _surfWave = ew;
            minDist = dist;   
         }
      }
   }


 // Given the EnemyWave that the bullet was on, and the point where we
 // were hit, calculate the index into our stat array for that factor.
   public static double getFactor(EnemyWaveDC ew, Point2D.Double targetLocation) {
      return Utils.normalRelativeAngle(absoluteBearing(targetLocation, ew.fireLocation) - ew.directAngle) * ew.direction
         /  Math.asin(8.0/ew.bulletVelocity);
   }


   public void onBulletHitBullet(BulletHitBulletEvent e){
      logEnemyBullet(e.getHitBullet());
   }
   public void onHitByBullet(HitByBulletEvent e) {
     
      logEnemyBullet(e.getBullet());
      enemyEnergy += 3*e.getBullet().getPower();
   }
   public void onBulletHit(BulletHitEvent e){
      enemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
   }
   public static void logEnemyBullet(Bullet b){
            // look through the EnemyWaves, and find one that could've hit us.
      Point2D.Double hitLocation =  new Point2D.Double(b.getX(), b.getY()); 
      Iterator it = enemyWaves.iterator();
      while (it.hasNext()) {
         EnemyWaveDC ew = (EnemyWaveDC)it.next();
         
         if (Math.abs(ew.distanceTraveled - hitLocation.distance(ew.fireLocation)) <= 40
                 // && Math.abs(Rules.getBulletSpeed(b.getPower()) - ew.bulletVelocity) < 0.1
            	  ) {
            ew.scan[0] = getFactor(ew,hitLocation);
            hitScans.add(ew.scan);
            //hitCounter++;
             // We can remove this wave now, of course.
            it.remove();
         }
      }
   
   }

 // CREDIT: mini sized predictor from Apollon, by rozu
 // http://robowiki.net?Apollon

   public  double checkDanger(int direction) {
      Point2D.Double predictedPosition = myLocation;
      double predictedVelocity = getVelocity();
      double predictedHeading = getHeadingRadians();
      double moveAngle, moveDir;
      
      int counter = 0; // number of ticks in the future
   
      do {
         moveAngle =
             wallSmoothing(predictedPosition, absoluteBearing(predictedPosition,enemyLocation) + (direction * 2), direction)
             - predictedHeading;
         moveDir = 1;
      
         if(Math.cos(moveAngle) < 0) {
            moveAngle += Math.PI;
            moveDir = -1;
         }
      
         predictedPosition = project(predictedPosition,
            predictedHeading +=
            posNegLimit(Utils.normalRelativeAngle(moveAngle),
              Rules.getTurnRateRadians(Math.abs(predictedVelocity)))
             ,
              predictedVelocity = posNegLimit(predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir), 8)
              );
            
      } while(_surfWave != null && predictedPosition.distance(_surfWave.fireLocation) //- 18
      > _surfWave.distanceTraveled + ++counter*_surfWave.bulletVelocity);
   
      predictedVelocity = 1;
      if(_surfWave != null){
         //predictedVelocity = getDanger( getFactor(_surfWave,predictedPosition), _surfWave.scan);
         
         //predictedVelocity = 0; - don't need, since it is all relative!
         predictedHeading = getFactor(_surfWave,predictedPosition);
         Iterator i = hitScans.iterator();
         while(i.hasNext()){
            double[] scan = (double[])i.next();
            double dist = 0;
            for(direction = 1; direction < scan.length; direction++){
               dist += Math.abs(_surfWave.scan[direction] - scan[direction]);
            }
            predictedVelocity += 1/(dist*((1.0/50) + Math.abs(predictedHeading - scan[0])));
         }
      }
      
      return predictedVelocity/predictedPosition.distanceSq(enemyLocation);
   }
   // final static double getDanger(double GF, double[] location){
      // double danger = 0;
      // Iterator i = hitScans.iterator();
      // while(i.hasNext()){
         // double[] scan = (double[])i.next();
         // double dist = 0;
         // for(int j = 1; j < location.length; j++){
            // dist += Math.abs(location[j] - scan[j]);
         // }
         // danger += 1/dist/((1.0/50) + Math.abs(GF - scan[0]));
      // }
      // return danger;
   // }

   // public static double offset(double distance){
   //    //return 2 + (int)(150/distance);
      // return 2;//(Math.PI/2 + 0.4) - (0.4/475)*distance;
   // }
    // public void onDeath(DeathEvent e){
      // System.out.println("!!!!LOSS!!!!!");
      // System.out.println("   myLocation: (" + myLocation.x + ";" + myLocation.y);
      // System.out.println("enemyLocation: (" + enemyLocation.x + ";" + enemyLocation.y);
   // }

 // This can be defined as an inner class if you want.
   static class EnemyWaveDC {
      Point2D.Double fireLocation;
      int direction;
      double[] scan;
      double bulletVelocity, directAngle, distanceTraveled;
   }

 // CREDIT: Iterative WallSmoothing by Kawigi
 //   - return absolute angle to move at after account for WallSmoothing
 // robowiki.net?WallSmoothing
   public static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
      do {
         angle -= orientation*0.05;
      }while (!fieldRect.contains(project(botLocation, angle, WALL_STICK)));
      return angle;
   }

 // CREDIT: from CassiusClay, by PEZ
 //   - returns point length away from sourceLocation, at angle
 // robowiki.net?CassiusClay
   public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
      return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
         sourceLocation.y + Math.cos(angle) * length);
   }

 // got this from RaikoMicro, by Jamougha, but I think it's used by many authors
 //  - returns the absolute angle (in radians) from source to target points
   public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
      return Math.atan2(target.x - source.x, target.y - source.y);
   }

   public static double posNegLimit(double value, double max) {
      return Math.max(-max, Math.min(value, max));
   }


}
