package pb;
import robocode.*;
//import java.awt.Color;

/**
 * Oscillator - a robot by (your name here)
 */
public class Oscillator extends AdvancedRobot
{
	double turnAngle=74,aheadDistance=500;
	/**
	 * run: Oscillator's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		turnGunRight(getHeading()+90-getGunHeading());
		setAdjustGunForRobotTurn(true);
		while(true) {
			// Replace the next 4 lines with any behavior you would like
				setTurnRadarRight(Double.POSITIVE_INFINITY);
				setTurnRight((turnAngle*=-1)*Math.random());
				setAhead((aheadDistance*=-1)*Math.random());
				//setTurnGunRight(Double.POSITIVE_INFINITY);
				waitFor(new MoveCompleteCondition(this));
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if(e.getDistance()<40) {setBack(20);execute();};
		turnGunRight(e.getBearing()+getHeading()-getGunHeading()+15*Math.random());
		if(getEnergy()>10 &&getGunHeat()==0 && Math.abs(e.getBearing()+getHeading()-getGunHeading())<15)
		fire(Math.max(.5,Math.min(3,500/e.getDistance())));
		setTurnRight(e.getBearing()+100*Math.random());
		setAhead(200);
		setTurnRadarRight((e.getBearing()+getHeading()-getRadarHeading())*2);
        execute();
	}
	
	public void onHitWall(HitWallEvent hwe)
	{
		turnRight(90);ahead(50);
	 }
	
	public void onHitRobot(HitRobotEvent hre)
	{
		turnGunRight(hre.getBearing()+getHeading()-getGunHeading());
		if(getGunHeat()==0)
		fire(3);
		setTurnRadarRight((hre.getBearing()+getHeading()-getRadarHeading())*2);
		back(100*Math.random());
	}
     
	public void onHitByBullet(HitByBulletEvent hbbe)
	{
		setBack(100*Math.random());
		setTurnLeft(90*Math.random());
		execute();
	}
	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */

	
}
