
package dsx724;

import robocode.*;

import java.awt.Color;
import java.lang.Math;

import dsx724.EventProcessors.EventProcessor3a;

public class VSAB_EP3a extends AdvancedRobot {
	private static final double R2D = 180 / Math.PI;
	private static final boolean DEBUG = false;
	private boolean radar = true;
	
	private StatsProcessor sp = new StatsProcessor();
	
	private EventProcessor3a ep3 = new EventProcessor3a(this);
	// 0 none, 1 basic, 2 intermediate, 3 advanced
	private int bodymode = 2;
	private int gunmode = 2;
	private int radarmode = 3;
	
	private int trick = 3;
	
	private double enemyenergy = 100;
	private double enemyattack = 0;
	private double damagetoenemy = 0;

	//private boolean wall = true;
	private double bodymode2dist = 0;
	
    public void run() {
        setColors(Color.GREEN, Color.GREEN, Color.GREEN);
        setAdjustRadarForGunTurn(true);
        setAdjustRadarForRobotTurn(true);
        setAdjustGunForRobotTurn(true);
        sweep();
    }
    public void sweep(){
    	setTurnRadarRight(810);
    	setTurnGunRight(360);
    	setTurnRight(180);
    }
    public void onScannedRobot(ScannedRobotEvent e){
    	if (damagetoenemy > 0){
    		enemyenergy -= damagetoenemy;
    		damagetoenemy = 0;
    	}
    	enemyattack = enemyenergy - e.getEnergy();
    	enemyenergy = e.getEnergy();
    	
		ep3.processScanEvent(e);
    	if (bodymode > 0)
    		body();
    	else if (bodymode < 0)
    		setTurnRight(99999);
    	if (gunmode > 0)
    		gun();
    	else if (gunmode < 0)
    		setTurnGunRight(99999);
    	if (radarmode > 0)
    		radar();
    	execute();
    }
    public void body(){
    	if (bodymode == 1){
    		if (Math.abs(getDistanceRemaining()) < 10){
	    		if (getDistanceRemaining() > 0)
	    			setBack(200);
	    		else
	    			setAhead(200);
    		}
    	}
    	if (bodymode == 2){
    		double turn = 0;
        	if (enemyattack > 0.25){
        		sp.logFireDetect(enemyattack);
        		System.out.println("Fire Detected: " + enemyattack);
        		if (Math.abs(getDistanceRemaining()) < 8){
        	    	bodymode2dist = Math.random() * 512 - 256;
        	    	setAhead(bodymode2dist);
        		}
        	} else {
        		if (Math.abs(getDistanceRemaining()) == 0){
        	    	setAhead(trick);
        	    	trick =-trick;
        		}
        	}
        	double newx = getX() + Math.sin(getHeadingRadians());
        	double newy = getY() + Math.cos(getHeadingRadians());
        	bodymode2dist = Math.abs(bodymode2dist);
        	if (newx < 32){
        		if (getHeading() < 180)
        			setAhead(bodymode2dist);
        		else 
        			setBack(bodymode2dist);
        	} else if (newx > getBattleFieldWidth() - 32){
        		if (getHeading() < 180)
        			setBack(bodymode2dist);
        		else 
        			setAhead(bodymode2dist);
        	} else if (newy < 32){
        		if (getHeading() < 90 || getHeading() > 270)
        			setAhead(bodymode2dist);
        		else 
        			setBack(bodymode2dist);
        	} else if (newy > getBattleFieldHeight() - 32){
        		if (getHeading() < 90 || getHeading() > 270)
        			setBack(bodymode2dist);
        		else 
        			setAhead(bodymode2dist);
        	}
        	
        	
    		double[] results = ep3.getRelativePredictedLocation(1);
    		double relativeenemyheading = Math.atan2(results[0], results[1]) * R2D;
    		turn = relativeenemyheading - getHeading();
    		double capturn = cap180(turn);
    		if (capturn > 0){
    			turn -= 90;
    			if (getDistanceRemaining() > 0)
    				turn += 1;//Rules.getTurnRate(getVelocity());
    			else if (getDistanceRemaining() < 0)
    				turn -= 1;//Rules.getTurnRate(getVelocity());
    		}
    		else {
    			turn += 90;
    			if (getDistanceRemaining() > 0)
    				turn -= 1;//Rules.getTurnRate(getVelocity());
    			else if (getDistanceRemaining() < 0)
    				turn += 1;//Rules.getTurnRate(getVelocity());
    		}
    		setTurnRight(cap180(turn));
    	}
    }
    public void gun(){
    	double turn = 0;
    	double fp = Math.max(0.1, Math.log10(sp.getAccuracy(8)[0]) + 125 / ep3.e.getDistance());
    	double[] bonus = sp.getAccuracy();
		if (bonus[0] > 25){
			fp += 0.3;
    		if (bonus[0] > 50)
    			fp += 0.3;
		}
    	fp = Math.max(0.5, fp);
    	if (gunmode == 1){
    		turn = getHeading() + ep3.e.getBearing() - getGunHeading();
    	} else if (gunmode == 2){
    		double edistance = ep3.e.getDistance();
    		int reachturns = (int)(edistance / Rules.getBulletSpeed(fp));
    		double[] results = ep3.getRelativePredictedLocation(reachturns);
    		edistance = Math.sqrt(results[0] * results[0] + results[1] * results[1]);
    		double reh = 0;
    		for (int i = 0; i < 8; i ++){
	    		reachturns = (int)(edistance / Rules.getBulletSpeed(fp));
	    		double[] nresults = ep3.getRelativePredictedLocation(reachturns);

	    		reh = Math.atan2(nresults[0], nresults[1]) * R2D;
	    		edistance = Math.sqrt(nresults[0] * nresults[0] + nresults[1] * nresults[1]);
	    		turn = reh - getGunHeading();
	    		if (nresults[0] == results[0] && nresults[1] == results[1])
	    			i = 8;
    			else
	    			results = nresults;
    		}
    		/*
    		double[] pred = ep3.getPredictedLocation(reachturns);
    		sp.setPrediction(new double[]{pred[0], pred[1], reachturns});
    		pred = sp.incrementTurn();
    		
    		double dx = pred[0] - ep3.track[0][0];
    		//System.out.println("ERRORDX: " + dx);
    		double dy = pred[1] - ep3.track[0][1];
    		//System.out.println("ERRORDY: " + dy);
    		double dz = Math.sqrt(dx * dx + dy * dy);
    		if (dz < 20)
    			System.out.println("Error: Acceptable");
    		else
    			System.out.println("Error: Unacceptable - " + (int)dz);
    			*/
    	}
		turn = cap180(turn);
    	setTurnGunRight(turn);
    	if (getGunHeat() == 0 || Math.abs(getGunTurnRemaining()) < 2){
    		fp = Math.min(fp, 3);
    		//System.out.println("Fire: " + fp);
        	if (getEnergy() > 0.5){
        		setFire(fp);
	    		if (DEBUG)
	    			System.out.println("Firepower: " + fp);
        	}
    	}
    }
    public void radar(){
    	double turn = 720;
    	if (radarmode == 2){
    		radar = !radar;
	    	if (radar)
	    		turn = -turn;
    	} else if (radarmode == 3){
    		double[] results = ep3.getRelativePredictedLocation(1);
    		double[] aresults = ep3.getLocation();
    		double[] presults = ep3.getPredictedLocation(1);
    		if (DEBUG)
    			System.out.println("Radar Error: \t" + (int)(presults[0] -aresults[0]) + "\t" + (int)(presults[1] - aresults[1]));
    		if (DEBUG){
    			String s = "";
    			for (double d : results){
    				s += d + " ";
    			}
    			System.out.println("Event Processor: " + s);
    		}
    		double relativeenemyheading = Math.atan2(results[0], results[1]) * R2D;
    		if (DEBUG)
    			System.out.println("REH: " + relativeenemyheading);
    		turn = relativeenemyheading - getRadarHeading();
    		if (DEBUG)
    			System.out.println("Turn: " + turn);
    		turn = cap180(turn);
    		if (DEBUG)
    			System.out.println("CapTurn: " + turn);
    		
			double gunmod = 0;
			double botmod = 0;
    		if (turn > 0){
    			double maxturn = 10 - 0.75 * Math.abs(getVelocity());
    			if (getGunTurnRemaining() > 0){
    				gunmod = Math.min(getGunTurnRemaining(), Rules.GUN_TURN_RATE);
    			}
    			if (getTurnRemaining() > 0){
    				botmod = Math.min(getTurnRemaining(), maxturn);
    			}
    			if (gunmod == 0 && botmod == 0)
    				turn = 360;
    			else {
    				turn += (Rules.RADAR_TURN_RATE - gunmod - botmod) / 2;
    			}
    		} else {
    			double maxturn = 10 - 0.75 * Math.abs(getVelocity());
    			if (getGunTurnRemaining() < 0){
    				gunmod = Math.max(getGunTurnRemaining(), -Rules.GUN_TURN_RATE);
    			}
    			if (getTurnRemaining() < 0){
    				botmod = Math.max(getTurnRemaining(), -maxturn);
    			}
    			if (gunmod == 0 && botmod == 0)
    				turn = -360;
    			else {
    				turn += (-Rules.RADAR_TURN_RATE - gunmod - botmod) / 2;
    			}
    		}
    	}
    	setTurnRadarRight(turn);
    }
    public void onBulletHit(BulletHitEvent e){
    	//System.out.println("BH");
    	setColors(Color.RED, Color.RED, Color.RED);
    	sp.logBullet(true);
    	damagetoenemy += Rules.getBulletDamage(e.getBullet().getPower());
    }
    public void onBulletMissed(BulletMissedEvent e){
    	//System.out.println("BM");
    	setColors(Color.YELLOW, Color.YELLOW, Color.YELLOW);
    	sp.logBullet(false);
    }
    public void onBulletHitBullet(BulletHitBulletEvent e){
    	System.out.println("BHB");
    	sp.logBullet(false);
    }
    public void onHitRobot(HitRobotEvent e){
    	enemyenergy = e.getEnergy();
    }
    public void onHitByRobot(HitRobotEvent e){
    	bodymode2dist = -bodymode2dist;
    	enemyenergy = e.getEnergy();
    }
    public void onHitWall(HitWallEvent e){
    	//wall = true;
    }
    public void onHitByBullet(HitByBulletEvent e){
    	if (getRadarTurnRemaining() == 0){
    		sweep();
    	}
    }
    public void onRobotDeath(RobotDeathEvent e){
    	if (getRadarTurnRemaining() == 0){
    		sweep();
    	}
    }
    public void onDeath(DeathEvent e){
    	double[] stats = sp.getAccuracy();
    	System.out.println("A:" + stats[0] + "\tH:" + stats[1] + "\tT:"+ stats[2]);
    	System.out.println("Shots Detected: " + sp.getFD());
    }
    public void onWin(WinEvent e){
    	double[] stats = sp.getAccuracy();
    	System.out.println("A:" + stats[0] + "\tH:" + stats[1] + "\tT:"+ stats[2]);
    	System.out.println("Shots Detected: " + sp.getFD());
    }
    public double cap180(double arg0){
    	while (arg0 > 180){
    		arg0 -= 360;
    	}
    	while (arg0 < -180){
    		arg0 += 360;
    	}
    	return arg0;
    }
    public double cap360(double arg0){
    	while (arg0 >= 360){
    		arg0 -= 360;
    	}
    	while (arg0 < 0){
    		arg0 += 360;
    	}
    	return arg0;
    }
    public void setTurnRadarRight(double arg0){
    	if (DEBUG)
    		System.out.println(arg0);
    	super.setTurnRadarRight(arg0);
    }
    public void print(String s){
    	System.out.print(s);
    }
    public void println(String s){
    	System.out.println(s);
    }
}
