/*
 * Created on 11/11/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.gunner;

import java.awt.geom.*;

import java.text.DecimalFormat;
import java.util.*;

import axeBots.data.*;

import axeBots.AxeBot;
import axeBots.AxeException;
import axeBots.Musashi;
import axeBots.musashi.AxeTarget;
import axeBots.musashi.AxeVector;
import axeBots.util.RoboMath;
//import java.awt.geom.*;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class VectorPMGun extends AxeGunner {

    private double lastRate;
    /**
     * @param target
     * @param me
     * @param id 
     */
    private Point2D.Double targetPos= null;
    private Point2D.Double myPos= null;
    // private double diffHeads;
    private double head;
    private double maxDim;
    private double bvel;
    private Rectangle2D.Double field= null;

    //public static final int MAX_SAMPLES= 30000;

    //private BotData botData= null;
    //private ArrayList interpol= null;

    private AxeVector walkVec= new AxeVector(); //.clone();
    private AxeVector targetVec= new AxeVector(); //.clone();

    private long deltas[]= new long[10];

    public VectorPMGun(AxeTarget target, AxeBot me, int id) {
        super(target, me, id);
        double h= getMe().getBattleFieldHeight();
        double w= getMe().getBattleFieldWidth();
        maxDim= Math.sqrt(h * h + w * w);
    }

    protected Point2D.Double guess() {

        long ms= System.currentTimeMillis();

        //double diffHeads = 0;

        myPos= super.getMe().pos();
        targetPos= super.getTarget().pos();
        //targetDistance = myPos.distance(targetPos);

        //		if(super.getTarget().getDistance() < 100){
        //					return targetPos;
        //				}

        //botRecs= super.getTarget().getInterpolated();
        ArrayList interpols= getBotData().getInterpolated();
        ArrayList interpol= (ArrayList)interpols.get(interpols.size() - 1);

        field= AxeBot.getIt().getField();

        bvel= RoboMath.getBulletVelocity(super.getFirePower());

        int lim= (int)Math.ceil(maxDim / bvel);

        PatternSample now= null;

        try {
            now=
                new PatternSample(
                    interpol,
                    (int)getMe().getTime(),
                    myPos.distance(targetPos),
                    super.getTarget().getHeadToMe());
        } catch (AxeException e) {
            e.printStackTrace();
        }
        //(PatternSample)samplesList.get(samplesList.size() - 1);

        PatternSample.setOrderParams(
            now,
            getMe().getRoundNum(),
            (int)getMe().getTime() - lim);

        head= now.getOriginalAngle();

        deltas[0]= System.currentTimeMillis() - ms;

        Point2D.Double ret= newFindBestMatch();
        return ret;
    }

    private Point2D.Double intercept(PatternSample smp) {

        if (smp == null) {
            return null;
        }

        Point2D.Double ret= null;

        double bulDS, targetDS;
        double bulToTargetS;
        double diffHeads=
            RoboMath.normalRelativeAngle(head - smp.getOriginalAngle());
        int c= smp.getPos();

        ArrayList interpols= getBotData().getInterpolated();
        ArrayList interpol= (ArrayList)interpols.get(smp.getRound());

        targetVec.set(new Point2D.Double(0, 0), targetPos);
        walkVec.set(
            new Point2D.Double(0, 0),
            ((AxeVector)interpol.get(c)).getEndPoint());

        //1 passo
        if (!this
            .walk(
                ((AxeVector)interpol.get(++c)).getEndPoint(),
                diffHeads,
                walkVec,
                targetVec)) {
            return null;
        }

        bulToTargetS= 1;
        int times= 0;
        while ((bulToTargetS > 0) && (c < (interpol.size() - 2))) {
            if (!this
                .walk(
                    ((AxeVector)interpol.get(++c)).getEndPoint(),
                    diffHeads,
                    walkVec,
                    targetVec)) {
                return null;
            }

            bulDS= bvel * (++times);

            targetDS= myPos.distance(targetVec.getEndPoint());

            bulToTargetS= targetDS - bulDS;
        }

        ret= targetVec.getEndPoint();
        return ret;

    }

    protected boolean walk(
        Point2D.Double to,
        double diffHeads,
        AxeVector walkVec,
        AxeVector targetVec) {
        walkVec.set(walkVec.getEndPoint(), to);
        double ang= walkVec.getTheta() + diffHeads;
        targetVec.set(targetVec.getEndPoint(), ang, walkVec.getModule());
        return field.contains(targetVec.getEndPoint());
    }

    protected Point2D.Double newFindBestMatch() {
        //limite:
//		System.out.println("newFindBestMatch");
        long ms= System.currentTimeMillis();

        ArrayList universes= getBotData().getSamplesList();

        int rnds= universes.size();
        int maxWid= PatternSample.getMaxWideness();

        int bestsQtd= 50;
        Bests bests= new Bests(bestsQtd);
int age = getBotData().getSamplesSize();
        for (int i= 0; i < rnds; i++) {
        	
            ArrayList universe= (ArrayList)universes.get(i);
            for (int j= 0;
                ((j < universe.size()) && ((universe.size() - j) > maxWid));
                j++) {

                PatternSample s= (PatternSample)universe.get(j);
                s.setRound(i);
				s.setAge(age--);
                bests.add(s);
            }
        }

        PatternSample ps[]= bests.getArray();
        bestsQtd= ps.length;

        Point2D.Double points[]= new Point2D.Double[bestsQtd];
        double angs[]= new double[bestsQtd];
        double min= 400;
        double max= -400;

double refAng = RoboMath.getNRDegrees(myPos, ((Musashi)getMe()).getMyTarget().pos() );

        for (int i= 0; i < bestsQtd; i++) {
            points[i]= this.intercept(ps[i]);
            angs[i]=
                (points[i] == null)
                    ? Double.NaN 
                    : RoboMath.normalRelativeAngle (RoboMath.getNRDegrees(myPos, points[i])-refAng);
//            if (angs[i] < min) {
//                min= angs[i];
//            }
//
//            if (angs[i] > max) {
//                max= angs[i];
//            }
        }
        
//        System.out.println("min:"+min+" max:"+max);

//        double dif= (max - min) / 10D;
//        dif= (dif < 1) ? 1 : dif;

        deltas[3]= System.currentTimeMillis() - ms;
        ms= System.currentTimeMillis();

        ////////////
        int bestInd= RoboMath.rateAngs(angs,((Musashi)getMe()).getMyTarget().getDistance(),30  );
//        double minorVariation= Double.POSITIVE_INFINITY;
//
//        double major= Double.NEGATIVE_INFINITY;
//
//        for (int i= 0; i < bestsQtd; i++) {
//            if (points[i] == null) {
//                continue;
//            }
//            //double variation= 0;
//            double rate= 0;
//
//            for (int j= 0; j < bestsQtd; j++) {
//                double var=
//                    Math.abs(RoboMath.normalRelativeAngle(angs[i] - angs[j]));
//                //-(x^2)/(21.6^2)+100
//                rate += (points[j] == null)
//                    ? 0
//                    : 100 - (Math.pow(var, 2) / Math.pow(dif, 2));
//
//                //                variation += (points[j] == null)
//                //                    ? 0
//                //                    : Math.abs(RoboMath.normalRelativeAngle(angs[i] - angs[j]));
//            }
//
//            //            if (variation < minorVariation) {
//            //                bestInd= i;
//            //                minorVariation= variation;
//            //            }
//            //			if (variation < minorVariation) {
//            //							bestInd= i;
//            //							minorVariation= variation;
//            // }
//            if (rate > major) {
//                bestInd= i;
//                major= rate;
//            }
//        }

        deltas[4]= System.currentTimeMillis() - ms;

        //                getMe().out.println("universe:"+universe.size()+ 
        //                    " qtd:"
        //                        + bestsQtd
        //                        + " chosen:"
        //                        + bestInd
        //                        +" "+ps[bestInd] );

        return points[bestInd];
    }

    public boolean ready() {
        //getMe().out.println("not ready..");
        return getBotData().getSamplesListSize() > 0;
        //getMe().getTime() > PatternSample.getMaxWideness();
    }

    /**
     * @return
     */
    public double getLastRate() {
        return lastRate;
    }

}
