package kvk.Radar;
import kvk.Bots.Bot;
import kvk.Bots.BotManager;
import kvk.ExtendedRobot;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.Manager;
import robocode.*;

/**
 *  Classe de gestion des radars - Recherche de tous les bots
 *
 * @author     Ssin.le.Terrible
 * @created    9 janvier 2004
 */
public class RadarScanAll extends Manager {
	private  int  direction;

	public RadarScanAll(ExtendedRobot er) {
		super(er);
		direction = 1;
	}

	/**
	 *  Action  raliser chaque tour
	 */
	public void action() {
		if (Math.abs(myBot.getRadarTurnRemaining()) < 1d) {
			BotManager  botMap         = myBot.getBotManager();
			double      maxBearing     = 0;
			double      maxBearingAbs  = 0;
			int         nbBot          = 0;

			for (int i = 0; i < botMap.getSize(); i++) {
				Bot  tmpBot  = botMap.getBot(i);
				if (tmpBot != null && tmpBot.isUpdated() && !tmpBot.isDead()) {
					double  bearing  = Fct.relAngle(Fct.heading(myBot.getCoord(), tmpBot.getCoord()) - myBot.getRadarHeadingRadians());
					if (Math.abs(bearing) > maxBearingAbs) {
						maxBearingAbs = Math.abs(bearing);
						maxBearing = bearing;
					}
					nbBot++;
				}
			}

			double      turnAngle      = C._PI * direction;
			if (nbBot == myBot.getOthers()) {
				turnAngle = maxBearing + Fct.signe(maxBearing) * C._PI4 / 2d;
			}

			myBot.setTurnRadarRightRadians(turnAngle);
			direction = (int)Fct.signe(turnAngle);
		}
	}

	/**
	 *  Rinitialisation  effectuer chaque round
	 */
	public void reinitialise() {
	}
}

