package davidalves.net;

import robocode.*;
import davidalves.net.targeting.*;
import davidalves.net.data.*;
import davidalves.net.movement.*;
import davidalves.net.radar.*;
import davidalves.net.math.*;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;
import java.util.zip.*;


/**
 * @author David Alves
 *
 */


/*
 * 
 * EX PRAETERITO PRAESENS PRUDENTER AGIT NI FUTURA ACTIONE DETURPET. 
 * 
 * [Learning] from the past, the present acts prudently, lest it ruin future action.
 * 
 * 
 * 
 * 
 */
public class Duelist extends AbstractAdvancedBot implements Constants{
	
	static EnvironmentInterface environment;
	static MovementManager movementManager;
	static GunManager gunManager;
	static RadarManager radarManager;
	static Statistics statistics;
	public static StrategyDatabase strategyDatabase;
	
	Vector eventBuffer;
	Vector commandBuffer;
	
	public Duelist(){
		initialize();
	}
	
	void initialize(){
		
		//Keep the environment from last round, if possible
		if(environment == null)
			environment = new DuelEnvironment(this);

		movementManager = new MovementManager(this, environment);
	
		gunManager = new GunManager(this, environment);
		
		radarManager = new RadarManager(this, environment);
		
		if(statistics == null)
			statistics = new Statistics(this, environment);
	
		//Keep the strategy database from last round, if possible
		if(strategyDatabase == null)
			strategyDatabase = new StrategyDatabase(this, environment);
	
		eventBuffer = new Vector();
		commandBuffer = new Vector();
	}

	
	

	
	
	public void run() {

		if (getRoundNum() == 0){
			out.println("davidalves.net presents");
			//out.println("   ___           ___     __    ___    ___   ___ ");
			//out.println("  / _ \\__ _____ / (_)__ / /_  / _ \\  |_  | / _ \\");
			//out.println(" / // / // / -_) / (_-</ __/ / // / / __/_/ // /");
			//out.println("/____/\\_,_/\\__/_/_/___/\\__/  \\___(_)____(_)___/\n");
			//out.println();

			out.println(" ______            _______  _       _________ _______ _________");
			out.println("(  __  \\ |\\     /|(  ____ \\( \\      \\__   __/(  ____ \\\\__   __/");
			out.println("| (  \\  )| )   ( || (    \\/| (         ) (   | (    \\/   ) (   ");
			out.println("| |   ) || |   | || (__    | |         | |   | (_____    | |   ");
			out.println("| |   | || |   | ||  __)   | |         | |   (_____  )   | |   ");
			out.println("| |   ) || |   | || (      | |         | |         ) |   | |   ");
			out.println("| (__/  )| (___) || (____/\\| (____/\\___) (___/\\____) |   | |   ");
			out.println("(______/ (_______)(_______/(_______/\\_______/\\_______)   )_(   ");
			out.println();
			out.println("                       _______     __        ______ ");
			out.println("                      (  __   )   /  \\      / ____ \\");
			out.println("                      | (  )  |   \\/) )    ( (    \\/");
			out.println("                      | | /   |     | |    | (____  ");
			out.println("                      | (/ /) |     | |    |  ___ \\ ");
			out.println("                      |   / | |     | |    | (   ) )");
			out.println("                      |  (__) | _ __) (_ _ ( (___) )");
			out.println("                      (_______)(_)\\____/(_) \\_____/ ");
                              


			out.println("for information about this bot visit http://davidalves.net/robocode/");
		}
		
		
		if(getOthers()!=1){
			out.println("This robot's name is duelist, damn it, it's not meant for melee...\n");
			//error colors are defined in Constants.java
			setColors(ERROR_COLOR, ERROR_COLOR, ERROR_COLOR);
			while(true){
				scan();
			}
		}
		
		//Our motto
		out.println("EX PRAETERITO PRAESENS PRUDENTER AGIT NI FUTURA ACTIONE DETURPET");
		out.println("[Learning] from the past, the present acts prudently, lest it ruin future action.\n");
		
		//Set colors, colors are defined in Constants.java
		setColors(BODY_COLOR, GUN_COLOR, RADAR_COLOR);
		
		//Set up battle data
		environment.setBattleData(getOthers(), getBattleFieldHeight(), getBattleFieldWidth(), getRoundNum(), getNumRounds());
		
		//if(getRoundNum() > 0)
		//	out.println(strategyDatabase);	
		
		//Initial radar sweep, the radar sweeps much faster if we turn the gun and tank body too
		while(!environment.targetLocked()){
			radarManager.initialSweep();
			handleBufferedEvents();
		}
		//Now that the initial sweep is over, allow the parts to move independently for finer control
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		//loadStrategyDatabases();
		
		while (true){
			try{
				handleBufferedEvents();

				//environment.updateBattleData(getOthers(), getTime());
				environment.selectTarget();

				movementManager.manageMovement();
				gunManager.manageGun();
				radarManager.manageRadar();

				execute();
			
			} catch(NumberFormatException e){
			
				out.println("Exception thrown!\n");
				out.println(e);
				out.println("Re-initializing robot...");
				initialize();
				setColors(ERROR_COLOR, ERROR_COLOR, ERROR_COLOR);
			
			}
		}
	}
	
	

	
	
	void handleBufferedEvents(){
		Iterator iterator = eventBuffer.iterator();
		
		while (iterator.hasNext()){
			Object event = iterator.next();
			if (event instanceof SkippedTurnEvent)
				handleSkippedTurnEvent((SkippedTurnEvent)event);
				
			else if (event instanceof ScannedRobotEvent)
				handleScannedRobotEvent((ScannedRobotEvent)event);
				
			else if (event instanceof BulletHitEvent)
				handleBulletHitEvent((BulletHitEvent)event);
				
			else if (event instanceof BulletMissedEvent)
				handleBulletMissedEvent((BulletMissedEvent)event);
				
			else if (event instanceof HitRobotEvent)
				handleHitRobotEvent((HitRobotEvent)event);
				
			else if (event instanceof HitWallEvent)
				handleHitWallEvent((HitWallEvent)event);
				
			else if (event instanceof HitByBulletEvent)
				handleHitByBulletEvent((HitByBulletEvent)event);
				
			else if (event instanceof RobotDeathEvent)
				handleRobotDeathEvent((RobotDeathEvent)event);
				
			else if (event instanceof DeathEvent)
				handleDeathEvent((DeathEvent)event);
				
			else if (event instanceof WinEvent)
				handleWinEvent((WinEvent)event);
				
			iterator.remove();
		}
	}


/////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////// Error and Warning Handlers /////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public void warning(String module, String errorMessage){
		statistics.addWarning();
		super.warning(module, errorMessage);
	}
	
	public void error(String module, String errorMessage){
		statistics.addError();
		super.error(module, errorMessage);
	}
	
/////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// Event Handlers ////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

	void handleScannedRobotEvent(ScannedRobotEvent e) {	
		//out.println(">>> ScannedRobotEvent");
		if(strategyDatabase == null){
			strategyDatabase = new StrategyDatabase(this, environment);
		}
		environment.updateScanData(e, this);
	}
	
	void handleRobotDeathEvent(RobotDeathEvent e) {
		environment.robotDied(e.getName());
	}
	
	void handleBulletMissedEvent(BulletMissedEvent e) {
		statistics.bulletMiss();
	}

	void handleBulletHitEvent(BulletHitEvent e) {
		statistics.bulletHit();
	}

	void handleWinEvent(WinEvent e){
		statistics.printEndOfRoundStatistics();
		movementManager.wonRound();
		//Garbage collect at the end of each round in an effort to prevent those damn out of memory errors
		System.gc();
	}
	
	void handleDeathEvent(DeathEvent e){
		environment.robotDied(getName());
		statistics.printEndOfRoundStatistics();
		movementManager.lostRound();
		out.println("\nI died :-(\n");
	}
	
	void handleSkippedTurnEvent(SkippedTurnEvent e){
		out.println("WARNING!!! Skipped a turn");
		//warning("Duelist:onSkippedTurn()", "SkippedTurnEvent at time: " + e.getTime());
		statistics.skippedTurn();
	}
	
	void handleHitRobotEvent(HitRobotEvent e) {
		out.println("Rammed by " + e.getName());
	}
	
	void handleHitByBulletEvent(HitByBulletEvent e){
		//movementManager.hitByBullet(DaveMath.damageDoneByPower(e.getPower()));
	}
	
	void handleHitWallEvent(HitWallEvent e){
		
	}
	
/////////////////////////////////////////////////////////////////////////////////////////
//////////////// Overloaded event handlers from class AdvancedRobot /////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public void onScannedRobot(ScannedRobotEvent e) {
		eventBuffer.add(e);
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		eventBuffer.add(e);
	}
	
	public void onBulletMissed(BulletMissedEvent e) {
		eventBuffer.add(e);
	}

	public void onBulletHit(BulletHitEvent e) {
		eventBuffer.add(e);
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e) {
		eventBuffer.add(e);
	}

	public void onWin(WinEvent e){
		eventBuffer.add(e);
	}
	
	public void onDeath(DeathEvent e){
			
		//Unlike all other events, this one cannot be buffered,
		//because the round will end for us after this event handler is called.
		handleDeathEvent(e);
	}

	public void onHitWall(HitWallEvent e){
		eventBuffer.add(e);
	}

	public void onHitRobot(HitRobotEvent e) {
		eventBuffer.add(e);
	}

	public void onSkippedTurn(SkippedTurnEvent e){
		eventBuffer.add(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e){
		eventBuffer.add(e);
	}
}
