package gh.ghgun;

import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import robocode.util.Utils;
import gh.ghutils.*;
//import robocode.Rules;

// check the !??! : these are things to do / to check

/**
 * GresVretter - a gun by Gert Heijenk
 *
 * Targeting system including:
 * - GuessFactorTargeting (2 almost identical guns)
 * - Anti-Surfer gun
 * - Passive BulletShadows
 *
 * Although the code itself is mine, the refactoring is inspired by Dookious by Voidious
 *
 * Code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */

public class GresVretter {
	// some constants
	static final String VERSION			= "0.4.9";
	static final double WALLMARGIN		= 17.9;
	static final double BLINDMANSTICK	= 110;	// max blindmanstick for enemies predicted movement
	static final double RAMBOTDISTANCE	= 120;
	static final double RAMFIREPOWER	= 3.00;	// rambot firepower
	static final double MAXFIREPOWER	= 2.65;	// close range firepower
	static final double STDFIREPOWER	= 1.95;	// standard firepower
	static final double MINFIREPOWER	= 0.15;	// shooting 'peas' for energy management reasons
	static final double DUCKFIREPOWER	= 0.1;	// real minimum firepower, only for sitting ducks
    public static boolean TC_flag		= false;	// TargetingChallenge

	static double [] powerlist = { RAMFIREPOWER, MAXFIREPOWER, 2.15, STDFIREPOWER, 1.65, 1.45, 1.15, 0.95, 0.65, 0.45, MINFIREPOWER, MINFIREPOWER };

	ArrayList<GunWave> waveList;
	GunWave	newWave;
	
	// guns: 
    private static ArrayList<GunStat> gunList = new ArrayList<GunStat>();

	int currTime;					// the current scantime
	double firePower;				// the power I will shoot with, calculated previous tick
	boolean fireWaves;				// do not fire virtual waves until opponent starts moving
	int duckShot;					// Timer for shot taken at sitting duck, do not fire more bullets
	
    AdvancedRobot robot;

	/**
	 * GresVretter
	 */
    public GresVretter( AdvancedRobot robot, boolean tc_Flag) {
		this.robot = robot;
		TC_flag = tc_Flag;

		waveList = new ArrayList<GunWave>();
		newWave = new GunWave();
		
		if (robot.getRoundNum() == 0) {
	        // initialize the guns (virtualwave weight, decay, antisurf)
			GunStat gun = new GunStat( 0.05, 0.75, 1.0);	// gun 3
			gunList.add(0, gun);
			gun = new GunStat( 0.07, 0.88, 0.0);	// gun 2
			gunList.add(0, gun);
			gun = new GunStat( 0.14, 1.0, 0.0);		// gun 1
			gunList.add(0, gun);
		    System.out.println("GresVretter gun version: " + VERSION);
		}
		for (int i = 0; i < gunList.size(); i++) {
			gunList.get(i).newRound();
		}
	}

	// onScannedRobot: Event from scanning another robot
	// 		information gathering has been done in TickState
    public void onScannedRobot( ScannedRobotEvent e) {
		currTime = newWave.fireTime = (int)robot.getTime();

		if (TickState.getEnSpeed() != 0.0) {
			fireWaves = true;		// do not count 'sur place' at beginning of round
		}
		
		doCheckWaves();

		// if my or enemies energy significantly changed, do not fire this tick (rare)
		double newfirePower = doFirePower(e.getEnergy());
		if (Math.abs( newfirePower - firePower) < 0.26)
			doFireGun();

		// start with the preparation for next tick, with estimation for next positions
		firePower = newfirePower;
		TickState.setMyFirePower( firePower);
		newWave = new GunWave();
		newWave.fireLocation.setLocation( TickState.getMyNextPos());
		newWave.HOTAngle = GHUtils.doGetAngle( TickState.getMyNextPos(), TickState.getEnemyNextPos());
		doMoveGun();
	}

	/**
	 * onBulletHitBullet: Do nothing here, virtual bullet still counts
	 */
    public void onBulletHitBullet( BulletHitBulletEvent e) {
//		System.out.println("BulletHitBullet !");
    }

	// onBulletHit: Anti-surfer gun needs info about hitted bin
    public void onBulletHit( BulletHitEvent e) {
		Point2D.Double hitBulletLocation = new Point2D.Double( e.getBullet().getX(), e.getBullet().getY());
		double bspeed = e.getBullet().getVelocity();
		int i;
		GunWave hitWave = null;

		// look through the real GunWaves, and find the one that should've hit us.
		for (i = waveList.size() - 1; i >= 0; i--) {
			GunWave currWave = (GunWave)waveList.get( i);
		    if ((currWave.bulletWave == true) && (bspeed == currWave.bulletVelocity)) {
				double wavedist = currWave.bulletVelocity * ( currTime - currWave.fireTime);
				double bulldist = currWave.fireLocation.distance( hitBulletLocation);
				if (Math.abs(bulldist - wavedist) < GHUtils.BOTWIDTH) {
					hitWave = currWave;
					break;
				}
			}
		}
		if (hitWave != null) {
			hitWave.hittedBin = hitWave.getHittedBin( hitBulletLocation);
		}
	}

	/**
	 * onWin: Start with the victory dance
	 */
	public void onWin(WinEvent e)
	{
		//Victory dance	
		robot.setTurnGunRight( Double.POSITIVE_INFINITY);
		robot.setTurnRadarLeft( Double.POSITIVE_INFINITY);
	}

	// onDeath: I died, but handle some waves touching the enemy
	public void onDeath(DeathEvent e)
	{
		// for every still available wave
		for (int j = waveList.size() - 1; j >= 0; j--) {
		    GunWave currWave = (GunWave)waveList.get( j);

			// only if wave already touched target
			if (currWave.getmaxbin() > 0) {
				// All guns: update every bin that would have hit
//System.out.println("Extra update bins "+ currWave.getminbin()+" - "+currWave.getmaxbin());
				for (int i = 0; i < gunList.size(); i++) {
					gunList.get(i).update(currWave);
				}
			}
			waveList.remove(j);			// remove when wave passed enemy

		}
	}

	// doFirePower: Select the optimal firepower to use
	// there is no one ideal formula for each situation, so there are quite some special cases. 
	double doFirePower( double eLife) {

		if (TC_flag == true)
			return Math.min( RAMFIREPOWER, robot.getEnergy());

		double power;
		int index = 0;
		// do energymanagement, but not at very close range
		if (TickState.getDistance(0) > RAMBOTDISTANCE) {
			double basepower = (TickState.getDistance(0) > (RAMBOTDISTANCE * 1.5) ? STDFIREPOWER : MAXFIREPOWER);
			double killpower = (eLife <= 4.0 ? eLife/4.0 : (eLife + 2.0)/6.0);
			double balancedpower = robot.getEnergy() / 15;
			power = Math.min( killpower, Math.min( balancedpower, basepower));
			if (power > DUCKFIREPOWER) {					// enough energy left, exploit firepower x.x5 bug
				while ( index < powerlist.length - 2) {
					if ( power >= powerlist[index])
						break;
					index++;
				}
			} else {
				index = powerlist.length - 2;	// for survival reasons, shoot absolute minimum
			}
			// high hitrate => fire heavier
			if (TickState.getHitRate() > 0.85) {
				index--;
//			} else if (TickState.getHitRate() > 0.30) {
//				// but never RAMFIREPOWER and not kill a mouse with a canon, except when ridiculous hitrate
//				if ((index > 1) && (killpower > MINFIREPOWER)) {
//					index--;
//				}
//			} else if (robot.getEnergy() > 10 && robot.getEnergy() < 60 && robot.getEnergy() < eLife) {
//				index++;	// midbattle fire lighter if opponent has more energy
			}
		}
		else {	// close range, ignore energymanagement, always shoot heavy
			index = (TickState.getCollisions() > (robot.getRoundNum() + 1)) ? 0 : 1;
		}
		power = powerlist[index];
		return power;
	}

	// doMoveGun: Move the gun to the optimal (estimated) angle to hit the target
	void doMoveGun() {
		// aim HOT if enemy is disabled or gun is hot
		if (TickState.isSittingDuck() || (robot.getGunHeat() > 0.29))  {
			for (int i = 0; i < gunList.size() ; i++) {
				newWave.gunBin[i] = GHUtils.GMIDBIN;
			}
		}
		else {
			// check if minbin and maxbin can reach target without ending up in wall
			int minbin = doCheckMEA ( -1 );	// reverse direction
			int maxbin = doCheckMEA (  1 );	// continue direction

//			System.out.println(" min: " + minbin + " max: " + maxbin);
			// !??! // swap if necessary (only with rambots?)
			if (minbin > maxbin) {
				int tmpbin = minbin;
				minbin = maxbin;
				maxbin = tmpbin;
//				System.out.println(" Swap minbin <=> maxbin !!");
			}
			// head-on should always be possible ! !??! especially with rambots this is needed
//			if (minbin > GHUtils.GMIDBIN) { minbin = GHUtils.GMIDBIN - 4; System.out.print(currTime+" minbin wrong!"); }
//			if (maxbin < GHUtils.GMIDBIN) { maxbin = GHUtils.GMIDBIN + 4; System.out.print(currTime+" maxbin wrong!"); }
//System.out.println(" min: " + minbin + " max: " + maxbin + "currspeed: "+ TickState.getEnSpeed(0));
			
			// get best bin for all guns
			for (int i = 0; i < gunList.size() ; i++) {
//				newWave.gunBin[i] = gunList.get(i).getBestIndex( minbin, maxbin,
//												 0,
//												 TickState.getEnVelBin(),
//												 0,
//												 0);
				newWave.gunBin[i] = gunList.get(i).getBestIndex( minbin, maxbin,
												 TickState.getEnAccBin(),
												 TickState.getEnVelBin(),
												 TickState.getEnWallBin(),
												 TickState.getEnDL14Bin());
			}
		}

		int bestgun = 0;
		for (int i = 1; i < gunList.size(); i++) {
			if (gunList.get(i).getGunAvgHit() > gunList.get(bestgun).getGunAvgHit()) {
				bestgun = i;
			}
		}
		newWave.bestGun = bestgun;
//System.out.println("Bestgun: "+ bestgun);

		// this should do the opposite of the math in the WaveBullet:
		double guessfactor = (double)(newWave.gunBin[bestgun] - GHUtils.GMIDBIN) / GHUtils.GMIDBIN;
		double angleOffset = TickState.getEnDirection(0) * guessfactor * Math.asin( Rules.MAX_VELOCITY / Rules.getBulletSpeed( firePower));
		double anglerandom = (Math.random() < 0.5 ? 0.6 : -0.6) / TickState.getDistance(0);		// imperfection to lure bulletcatchers
		double bestangle = angleOffset + anglerandom;
		robot.setTurnGunRightRadians( Utils.normalRelativeAngle( newWave.HOTAngle - robot.getGunHeadingRadians() + bestangle));
	}

	// doFireGun: Fire the gun.
	void doFireGun() {

		// firepower is determined previous tick, so do extra checks to prevent disableing ourselves
		if ((TC_flag == false) && (TickState.getDistance(0) > RAMBOTDISTANCE)) {
			if (!TickState.isSittingDuck()) {
				duckShot = 0;
				if (robot.getEnergy() <= firePower)
					firePower = 0.0;
			}
			if (TickState.isSittingDuck() && (firePower > 0.01)) {
				if (--duckShot <= 0) {
					if (robot.getGunHeat() == 0.0) {
						firePower = DUCKFIREPOWER;
						duckShot = (int)(TickState.getDistance(0) / Rules.getBulletSpeed( DUCKFIREPOWER)) + 1;		// fire once until hit or missed
						System.out.println("Firing at sitting Duck . . .");
					}
				}
				else firePower = 0.0;
			}
		}

		newWave.direction = TickState.getEnDirection(0);
		newWave.bulletVelocity = Rules.getBulletSpeed( firePower);
		newWave.maxEscAngle = Math.asin( Rules.MAX_VELOCITY / newWave.bulletVelocity);
//		newWave.accelerationBin = 0;
//		newWave.vlateralBin = 0;
//		newWave.wallProxBin = 0;
//		newWave.dist14Bin = 0;
		newWave.accelerationBin = TickState.getEnAccBin();
		newWave.vlateralBin = TickState.getEnVelBin();
		newWave.wallProxBin = TickState.getEnWallBin();
		newWave.dist14Bin = TickState.getEnDL14Bin();
		// set the real values instead of estimated values
		newWave.fireLocation.setLocation( TickState.getMyPos());
		newWave.HOTAngle = TickState.getAbsBearing(0);

		if ((robot.getGunHeat() == 0.0) && (robot.getGunTurnRemaining() == 0.0) && (firePower >= DUCKFIREPOWER)) {
			Bullet bullet = robot.setFireBullet( firePower);
//System.out.println(currTime+" firepower: "+firePower);
//System.out.println(currTime+" ab: "+newWave.accelerationBin+" vb: "+newWave.vlateralBin+" wb: "+newWave.wallProxBin+" db: "+newWave.dist14Bin);
			newWave.bulletWave = true;
			if (!TickState.isSittingDuck()) { 
				waveList.add( newWave);
				GunBullets.addBullet( bullet);
			}
		}
		else if (firePower >= MINFIREPOWER) { 
			if (fireWaves == true) {
				newWave.bulletWave = false;
				waveList.add( newWave);
//System.out.println(currTime+"  virtual wave");				
			}
		}
	}

	/**
	 * doCheckMEA: Check if the full MEA can be used, or just a subset
	 * When an opponent closes in on the wall, he can not reach the ultimate MEA.
     * Calculate the precise reacheable MEA, so no bullets end up in the wall.
     * The same for when reversing direction, calculate max reacheable bin.
	 * Instead of always calculating Precise MEA, just do it just before ready to fire.
	 * Note: direction = 1: continue, direction = -1: reverse
	 * Note: use Rozu's PredictPosition on enemies movement !??!
	 */
	int doCheckMEA( int direction) {
		Point2D.Double predictedPosition = (Point2D.Double)TickState.getEnemyNextPos().clone();
		double predictedVelocity = TickState.getEnSpeed();
		double predictedHeading = TickState.getEnHeading(0);
		double moveDir = Math.signum( direction * TickState.getEnSpeedSign());
		double clockwise = Math.signum( direction * TickState.getEnDirection(0));
		double bulletSpeed = Rules.getBulletSpeed( firePower);
		double maxTurning, moveAngle, angle, angledif;
		boolean intercepted = false;
		int ticks = 0;

//		if (moveDir == 0.0) { System.out.print("! mD !" + TickState.getEnSpeedSign());}
//		System.out.println("mD: " + moveDir + " eV: " + enemyVelocity + " eD: " + enemyDirection + " cw: " + clockwise);
		do {
			angle = GHUtils.doGetAngle( TickState.getMyNextPos(), predictedPosition);
			angledif = angle + (clockwise * Math.PI/2) - predictedHeading;
//			moveAngle = doWallSmoothing( predictedPosition, angle + (enemyDirection * direction * Math.PI/2)) - predictedHeading;
			moveAngle = doWallSmoothing( predictedPosition, angle + (clockwise * Math.PI/2), clockwise) - predictedHeading;

//			if ((ticks/2)*2 == ticks)
//				System.out.print("T:" + (ticks+1) + " ang: " + (int)(angle* 100)/100.0 + " mAng: " + (int)(moveAngle*100)/100.0 + " cos: "+ (int)(Math.cos(moveAngle)*100)/100.0);
			// this probably is done once if applicable
			if (Math.cos( angledif) < -0.4) {
				moveAngle += Math.PI;
//				System.out.print(" swap ");
			} else if ((Math.abs(Math.cos( angledif)) < 0.4) && (TickState.getEnSpeed(0) > 4.01)) {
				moveDir = Math.signum( predictedVelocity);
//			    System.out.print(" cont ");
			} else if (Math.cos( angledif) < 0.0) {
				moveAngle += Math.PI;
//				System.out.print(" swp2 ");
			}
//			} else System.out.print(" none ");

			moveAngle = Utils.normalRelativeAngle( moveAngle);
			
    		// maxTurning is built in like this, you can't turn more than this in one tick
    		maxTurning = Rules.getTurnRateRadians( Math.abs(predictedVelocity));  // bug if velocity is negative !
    		predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + Math.max(-maxTurning, Math.min(moveAngle, maxTurning)));

    		// Nice ;). if predictedVelocity and moveDir have different signs you want to brake down
    		// otherwise you want to accelerate (look at the factor "2")
 			predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
    		predictedVelocity = Math.max(-Rules.MAX_VELOCITY, Math.min(predictedVelocity, Rules.MAX_VELOCITY));
			
    		// calculate the new predicted position
    		predictedPosition = GHUtils.doProjectPos( predictedPosition, predictedHeading, predictedVelocity);
//			if ((ticks/2)*2 == ticks)
//				System.out.println("mAng: " + (int)(moveAngle*100)/100.0 + " predH: " + (int)(predictedHeading*100)/100.0 + " predV:" + predictedVelocity);

            // check if wave reached enemies predicted position
			if (predictedPosition.distance( TickState.getMyNextPos()) < (++ticks * bulletSpeed))
                intercepted = true;
				
			if (ticks > 200) {
				intercepted = true;
				System.out.println( "AAAAArgh, enemies predicted position is non-existing anymore");
			}
			if (direction == -1) {
				newWave.pntccw.add( (Point2D.Double)predictedPosition.clone());
			}
			else {
				newWave.pntcw.add( (Point2D.Double)predictedPosition.clone());
			}
								
    	} while (!intercepted);
		
		// just to paint max reacheable positions
		if (direction == -1) {
			newWave.pposccw.setLocation( predictedPosition);
//			System.out.println("edir " + enemyDirection + " CCWpos: " + predictedPosition);
		}
		else {
			newWave.pposcw.setLocation( predictedPosition);
//			System.out.println("edir " + enemyDirection + "  CWpos: " + predictedPosition);
		}

   		// take size of bot in account (rudimentary)
   		predictedPosition = GHUtils.doProjectPos( predictedPosition, predictedHeading, Rules.MAX_VELOCITY);

		// Now calculate max reacheable bin
		angle = Utils.normalRelativeAngle( GHUtils.doGetAngle( TickState.getMyNextPos(), predictedPosition) - 
										   GHUtils.doGetAngle( TickState.getMyNextPos(), TickState.getEnemyNextPos()));
		double mea = Math.asin( Rules.MAX_VELOCITY / bulletSpeed);
		double guessFactor = Math.max(-1, Math.min(1, angle / mea)) * TickState.getEnDirection(0);
		return ( (int)Math.round( GHUtils.GMIDBIN * ( guessFactor + 1.0)));
	}


	/**
	 * doWallSmoothing: Suppose the opponent uses some kind of wallsmoothing
	 * opponent always smooths towards me
	 */
	public double doWallSmoothing( Point2D.Double startPoint, double angle, double dirction) {
        // always turn towards enemy
		double di;
		double stick = Math.min( BLINDMANSTICK, TickState.getDistance(0)/2);
		for (di = Math.PI/2; di >= 0; di -= Math.PI/72) {
			if (!GHUtils.fireField.contains( GHUtils.doProjectPos( startPoint, angle + (di * dirction), stick))) {
				break;
			}
		}
		return ( angle + (di * dirction));
	}

	/**
	 * doCheckWaves: Check the status of the waves
	 */
	void doCheckWaves() {
		int i,j;

		// for every still available wave
		for (j = waveList.size() - 1; j >= 0; j--) {
		    GunWave currWave = (GunWave)waveList.get( j);

			// update statistics if wave has passed enemy
			if (currWave.wavepasscheck() == true) {
//				System.out.println("MinB "+currWave.getminbin()+" MaxB "+currWave.getmaxbin());

				// Decay in all guns, only if bulletwave
				if (currWave.bulletWave == true) {
					for (i = 0; i < gunList.size(); i++) {
						gunList.get(i).decay();
					}
				}

				// All guns: update every bin that would have hit
				for (i = 0; i < gunList.size(); i++) {
					gunList.get(i).update(currWave);
				}

//				if (currWave.bulletWave == true) {
//					System.out.println("Hits on bins:"+currWave.getminbin()+" till "+currWave.getmaxbin());
//				}
				// update gun statistics
				if (currWave.bulletWave == true) {
					TickState.gunfired++;
					gunList.get(currWave.bestGun).setGunFired();
					for (i = 0; i < gunList.size(); i++) {
						if ((currWave.gunBin[i] >= currWave.getminbin()) && (currWave.gunBin[i] <= currWave.getmaxbin()))
							gunList.get(i).setGunHit();
					}
				}	

				waveList.remove(j);			// remove when wave passed enemy
			}

			// remove all waves not touching the target, if enemy is disabled or killed
			else if (TickState.isSittingDuck() || (robot.getOthers() == 0)) {
				if (currWave.getmaxbin() == 0) 
					waveList.remove(j);
			}
		}
//		Point2D.Double bulpos = new Point2D.Double();
//		for (j = waveList.size() - 1; j >= 0; j--) {
//		    GunWave cw = (GunWave)waveList.get( j);
//			if (cw.bulletWave == true) {
//				bulpos = GHUtils.doProjectPos(cw.fireLocation, cw.HOTAngle, (currTime - cw.fireTime)*cw.bulletVelocity);
//				System.out.println(currTime+" Wavebulpos: "+ bulpos);
//				System.out.println("Wave angle : "+ Utils.normalAbsoluteAngle(cw.HOTAngle));
//			}
//		}
	}

	// printStats: Print statistics on end of round
	public void printStats() {
		if (TickState.gunfired > 0) {
			for (int i = 0; i < gunList.size(); i++) {
				System.out.println("Virtual Gun "+(i+1)+": " + (Math.round(gunList.get(i).getGunHit() * 10000 / TickState.gunfired) / 100.0 ) + "  ("+gunList.get(i).getGunFired()+")" );
			}
//			for (int i = 0; i < gunList.size(); i++) {
//				gunList.get(i).printSegVisits();
//			}
			
		}
	}

	/**
	 * onPaint: Show some gunnery stuff, maybe I am calculating something wrong
	 * updated 20110125: show angles of both guns and show angles that would have hit
     * updated 20110227: show max reacheable predicted positions of enemy
	 */
//	public void onPaint(java.awt.Graphics2D g) {
//		int j;
//		double dist;
//		Point2D botpos = new Point2D.Double();
//		Point2D vbpos = new Point2D.Double();

////		if (robot.getOthers() == 0) return;
//		// Make a rectangle around the enemy
//		if (ePosT.size() > 0) {
//			g.setColor( Color.yellow);
//			g.drawRect( (int)(enemyPos.getX() - HALFBOTWIDTH), (int)(enemyPos.getY() - HALFBOTWIDTH), (int)BOTWIDTH, (int)BOTWIDTH);
//		}

//		// for every still available wave
//		for (j = waveList.size() - 1; j >= 0; j--) {
//		    Wave currWave = (Wave)waveList.get( j);
//			if (currWave.bulletWave == true) {
//				dist   = currWave.getWaveDistance();
//				botpos = currWave.fireLocation;
//				g.setColor( Color.cyan);
//				vbpos  = doProjectPos( (Point2D.Double)botpos, currWave.gun1Angle + currWave.HOTAngle, dist);
//				g.drawLine( (int)botpos.getX(), (int)(botpos.getY()), (int)vbpos.getX(), (int)(vbpos.getY()));
//				g.setColor( Color.orange);
//				vbpos = doProjectPos( (Point2D.Double)botpos, currWave.gun2Angle + currWave.HOTAngle, dist);
//				g.drawLine( (int)botpos.getX(), (int)(botpos.getY()), (int)vbpos.getX(), (int)(vbpos.getY()));

//				g.setColor( Color.gray);
//				g.drawArc((int)(botpos.getX() - dist +1),(int)(botpos.getY() - dist+1),(int)(dist*2-2),(int)(dist*2-2), 
//				          (int)Math.toDegrees(currWave.HOTAngle - currWave.maxEscAngle), (int)Math.toDegrees(2 * currWave.maxEscAngle));

//				// show which angles are recorded as hit
//				if (currWave.maximumBin > 0) {
//					double angle = currWave.direction * ((double)(currWave.minimumBin - MIDBIN)/MIDBIN) * currWave.maxEscAngle + currWave.HOTAngle;
//					Point2D.Double pnt = doProjectPos(  (Point2D.Double)botpos, angle, dist);
//					g.drawLine( (int)botpos.getX(), (int)botpos.getY(), (int)pnt.x, (int)pnt.y);
//					angle = currWave.direction * ((double)(currWave.maximumBin - MIDBIN)/MIDBIN) * currWave.maxEscAngle + currWave.HOTAngle;
//					pnt.setLocation( doProjectPos(  (Point2D.Double)botpos, angle, dist));
//					g.drawLine( (int)botpos.getX(), (int)botpos.getY(), (int)pnt.x, (int)pnt.y);
//				}
//				// predicted positions (only for debugging?)
//				g.setColor( Color.green);
//				for (int i = 0; i < currWave.pntcw.size(); i++) {
//					vbpos.setLocation( (Point2D.Double)currWave.pntcw.get( i));
//					g.drawOval((int)(vbpos.getX() - 2), (int)(vbpos.getY() - 2), 4, 4);
//				}
//				g.drawRect( (int)(currWave.pposcw.getX() - HALFBOTWIDTH), (int)(currWave.pposcw.getY() - HALFBOTWIDTH), (int)BOTWIDTH, (int)BOTWIDTH);
//				g.setColor( Color.blue);
//				for (int i = 0; i < currWave.pntccw.size(); i++) {
//					vbpos.setLocation( (Point2D.Double)currWave.pntccw.get( i));
//					g.drawOval((int)(vbpos.getX() - 2), (int)(vbpos.getY() - 2), 4, 4);
//				}
//				g.drawRect( (int)(currWave.pposccw.getX() - HALFBOTWIDTH), (int)(currWave.pposccw.getY() - HALFBOTWIDTH), (int)BOTWIDTH, (int)BOTWIDTH);
//			}
//		}
//    }

}																																																							
