package bugger;
import robocode.*;
import java.awt.Color;
import java.io.*;
import java.awt.geom.Point2D;
import robocode.util.Utils;

/**
 * MyFirstLeader - a sample team robot by Mathew Nelson
 * 
 * Looks around for enemies, and orders teammates to fire
 */
public class HiveQueen extends TeamRobot
{
	double FORWARD = 1;//choose forward or backward
	double rand = 185;//a random number that changes
	/**
	 * run: Leader's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		setColors(Color.blue,Color.black,Color.black);
		setAdjustGunForRobotTurn(true);//allow gun to move
		                               //freely
		try {
			// Send RobotColors object to our entire team
			broadcastMessage(new RobotColors(Color.black,Color.blue,Color.blue));
		} catch (IOException e) {
		}
		// Normal behavior
		while(true) {
			setTurnRadarRight(10000);
			ahead(100);
			back(100);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// Don't fire on teammates
		if (isTeammate(e.getName()))
		{
			return;
		}
		//here I use an oscillating movement pattern, but
//I use a constant "rand" that I change randomly
//so that Patternmatchers can't lock onto me
if (getDistanceRemaining() == 0) { FORWARD =
	-FORWARD; setAhead(rand * FORWARD);}
setTurnRightRadians(e.getBearingRadians()
+Math.PI/2-0.5236*FORWARD
*(-1));
		// Calculate enemy bearing
		double enemyBearing = this.getHeading() + e.getBearing();
		// Calculate enemy's position
		double tenemyX = getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
		double tenemyY = getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));
		//here I get my enemy's statistics so that I can use
//linear targeting
		double bulletPower = Math.min(3.0,getEnergy());
		double myX = getX();
		double myY = getY();
		double absoluteBearing =
		 getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() 
		+ e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() 
		+ e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
//now I do my calculations for linear targeting so that
//I know where my enemy will be once my bullet gets there
		double deltaTime = 0;
double battleFieldHeight=
getBattleFieldHeight(),battleFieldWidth=
getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
while((++deltaTime)*(20.0
- 3.0*bulletPower)
<Point2D.Double.distance(myX, myY, predictedX, predictedY)){
		predictedX += Math.sin(enemyHeading) 
		* enemyVelocity;	
		predictedY += Math.cos(enemyHeading) 
		* enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
predictedX = 
Math.min(Math.max(18.0, predictedX), battleFieldWidth 
- 18.0);	
predictedY = 
Math.min(Math.max(18.0, predictedY), battleFieldHeight
- 18.0);
				break;}}
double theta =
Utils.normalAbsoluteAngle(Math.atan2(predictedX
- getX(), predictedY - getY()));
turnRadarRightRadians
(Utils.normalRelativeAngle(absoluteBearing 
- getRadarHeadingRadians()));
			try {
			// Send enemy position to teammates
			broadcastMessage(new Point(predictedX,predictedY));
		} catch (IOException ex) {
			System.out.println("Unable to send order: " + ex);
		}
	}

	/**
	 * onHitByBullet: Turn perpendicular to bullet path
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		turnLeft(90 - e.getBearing());
	}
}