package ags.polished;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;

import robocode.Event;

import ags.rougedc.painters.*;
import ags.rougedc.base.*;
import ags.rougedc.radar.BasicRadar;
import ags.rougedc.gun.FlammeRouge;

/**
 * @author Alexander Schultz
 */
public class PolishedRuby extends InformedBotBase {
    private BasicRadar radar;
    //private RougeMirrorOrbit mirror;
    private RougeMirror mirror;
    private FlammeRouge gun;
    
    @Override
    public void init() {
        super.init();
        
        // Set colors
        this.setColors(new Color(80, 0, 10), // Body color
                       new Color(25, 10, 10), // Scan color
                       new Color(50, 20, 20), // Gun color
                       new Color(20, 10, 10)); // Radar color
        this.setBulletColor(new Color(140, 100, 100));
        
        radar = new BasicRadar(getStatus(), getEnemies());
        //mirror = new RougeMirrorOrbit(getRules(), getStatus(), getEnemies());
        mirror = new RougeMirror(getRules(), getStatus(), getEnemies());
        gun = new FlammeRouge(getRules(), getStatus(), getEnemies());
    }

    @Override
    public void runTick(List<Event> events) {
        super.runTick(events);
        
        radar.run(getRadarActor());
        
        mirror.run(getMovementActor());
        
        gun.run(getGunActor());
    }
    
    @Override
    public void _onPaint(Graphics2D g) {
        WavePainter.paint(g, Color.RED, getEnemyWaveManager().getAll());
        GraphPainter.paintEnemyProfile(g, 1, 1, 70, 250, gun);
        WavePainter.paint(g, Color.CYAN, gun.getWaves());
    }
    
}