package pkdeken;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

/**
 * Paladin - a robot by (Pakistan)
 */
public class Paladin extends AdvancedRobot
{
	Color[] Color = new Color[5];
	ArrayList waves = new ArrayList();
	static int[] stats = new int[31];	//31 is the number of unique guessfactors we're using
	int direction = 1;
	private byte moveDirection = 1;
	private int tooCloseToWall = 0;
	private int wallMargin = 60;

	public void run()
	{
		addCustomEvent(new Condition("too_close_to_walls") {
				public boolean test() {
					return (
						// we're too close to the left wall
						(getX() <= wallMargin ||
						 // or we're too close to the right wall
						 getX() >= getBattleFieldWidth() - wallMargin ||
						 // or we're too close to the bottom wall
						 getY() <= wallMargin ||
						 // or we're too close to the top wall
						 getY() >= getBattleFieldHeight() - wallMargin)
						);
					}
				});
		while (true) 
		{
			
			if (getRadarTurnRemaining() == 0) 
				setTurnRadarRight(Double.POSITIVE_INFINITY);
         	execute();
		}
	}
	static final double FACTOR = 2.1;
	public void onCustomEvent(CustomEvent e) {
		if (e.getCondition().getName().equals("too_close_to_walls"))
		{
			if (tooCloseToWall <= 0) {
				tooCloseToWall += wallMargin;
				setMaxVelocity(0);
			}
		}
	}
	public void onScannedRobot(ScannedRobotEvent e)
	{  
		Random r = new Random();
		Color[4] = Color[3];
		Color[3] = Color[2];	
		Color[2] = Color[1];	
		Color[1] = Color[0];	
		Color[0] = new Color(r.nextInt(255),r.nextInt(255),r.nextInt(255));
		setBodyColor(Color[4]);
		setRadarColor(Color[3]);
		setGunColor(Color[2]);
		setBulletColor(Color[1]);
		setScanColor(Color[0]);
			   
		double absBearing = e.getBearingRadians() + getHeadingRadians();
     	setTurnRadarRightRadians( FACTOR*robocode.util.Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) );

		setTurnRight(e.getBearing()+90);
		
		//find our enemy's location:
		double ex = getX() + Math.sin(absBearing)*e.getDistance();
		double ey = getY() + Math.cos(absBearing)*e.getDistance();
		
		//let's process the waves now:
		for (int i=0; i<waves.size(); i++)
		{
			WaveBullet currentWave = (WaveBullet)waves.get(i);
			if (currentWave.checkHit(ex, ey, getTime()))
			{
				waves.remove(currentWave);
				i--;
			}
		}
		
		double power = Math.min(3, Math.max(.1,(e.getDistance()/8)));
		//don't try to figure out the direction they're moving if they're not moving, just use the direction we had before
		if (e.getVelocity() != 0)
			if (Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity() < 0)
				direction = -1;
			else
				direction = 1;
		int[] currentStats = stats;	//This seems silly, but I'm using it to show something else later
		WaveBullet newWave = new WaveBullet(getX(), getY(), absBearing, power, direction, getTime(), currentStats);
		int bestindex = 15;
		for (int i=0; i<31; i++)
			if (currentStats[bestindex] < currentStats[i])
				bestindex = i;
		
		//this should do the opposite of the math in the WaveBullet:
		double guessfactor = (double)(bestindex-(stats.length-1)/2)/((stats.length-1)/2);
		double angleOffset = direction * guessfactor * newWave.maxEscapeAngle();
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+angleOffset));
		if (setFireBullet(power) != null)
			waves.add(newWave);
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+angleOffset));
		if (tooCloseToWall > 0) tooCloseToWall--;

		// switch directions if we've stopped
		// (also handles moving away from the wall if too close)
		if (getVelocity() == 0) {
			setMaxVelocity(8);
			moveDirection *= -1;
		}		
			
		long n = getTime();
		setAhead(moveDirection*Math.sin(n/13)*Math.cos(n/11)*200);
		execute();
}
}
class WaveBullet
{
	private double startx, starty, startBearing, power;
	private long fireTime;
	private int direction;
	private int[] returnSegment;
	
	public WaveBullet(double x, double y, double bearing, double power, int direction, long time, int[] segment)
	{
		startx = x;
		starty = y;
		startBearing = bearing;
		this.power = power;
		this.direction = direction;
		fireTime = time;
		returnSegment = segment;
	}
	public double getBulletSpeed()
	{
		return 20-power*3;
	}
	
	public double maxEscapeAngle()
	{
		return Math.asin(8/getBulletSpeed());
	}
	public boolean checkHit(double enemyX, double enemyY, long currentTime)
	{
		//if the distance from the wave origin to our enemy has passed the distance the bullet would have traveled...
		if (Point2D.distance(startx, starty, enemyX, enemyY) <= (currentTime-fireTime)*getBulletSpeed())
		{
			double desiredDirection = Math.atan2(enemyX-startx, enemyY-starty);
			double angleOffset = Utils.normalRelativeAngle(desiredDirection-startBearing);
			double guessFactor = Math.max(-1, Math.min(1, angleOffset/maxEscapeAngle()))*direction;
			int index = (int)Math.round((returnSegment.length-1)/2*(guessFactor+1));
			returnSegment[index]++;
			return true;
		}
		return false;
	}
}			