package doka;

import robocode.*;
import robocode.util.*;
import java.awt.*;
import java.awt.geom.*;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html


/*
 * MicroBot based on Shinigami 1.1
 */

public class KillerRabbit extends AdvancedRobot
{
	// <UTILS>

	private double toRad(double angle){
		return angle*Math.PI/180;
	}
	private Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	
	private double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	// </UTILS>

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.white,Color.red,Color.white,Color.red,Color.white); // body,gun,radar,bullet,scanarc

		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		// Robot main loop
		while(true) {
			scan();
			execute();
		}
	}

	// TODO: static stopandgo?
	boolean stopandgo = true;
	int timesHit = 0;
	int dir = 1;

	double prevEnergy = 100.0;

	//                              0.0 0.5 1.0 1.5 2.0 2.5 3.0
	//                              0   1   2   3   4   5   6
	static int[] travelDistLookup = {19, 27, 33, 37, 48, 56, 64};

	public void onScannedRobot(ScannedRobotEvent e) {
		//radar lock
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
		setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle(radarTurn));
		
		//targeting
		double bulletPower = 2.49;
	 
		// dont use high power bullets if a smaller one will kill the enemy anyway
		bulletPower = Math.min(bulletPower, e.getEnergy()/4.0);
		// double bulletPower = Math.max(0.1,Math.random() * 3.0);
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		
		// double linearBearing = headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
		
		double escapeAngle = Math.asin(8 / Rules.getBulletSpeed(bulletPower));
		double randomAimOffset = -escapeAngle + Math.random() * 2 * escapeAngle;
		// if he is disabled, shoot head-on
		if(e.getEnergy() <= 0){
			randomAimOffset = 0;
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(headOnBearing + randomAimOffset - getGunHeadingRadians()));

		setFire(bulletPower);


		// movement

		double traveldist = 0;

		// if we're losing, change to alternative movement
		if(timesHit >= 2){
			stopandgo = false;
		}

		double dEnergy = prevEnergy-e.getEnergy();
		prevEnergy = e.getEnergy();
		if(stopandgo){
			// check if the enemy fired
			if(getDistanceRemaining() == 0.0 && dEnergy > 0 && dEnergy <= 3.0){
				// look up distance we can travel before the enemy can fire again
				traveldist = travelDistLookup[(int)(dEnergy*2)];
			}
		}else{
			traveldist = 100;
		}

		double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyDistance = e.getDistance();
		Point2D robotLocation = new Point2D.Double(getX(), getY());
		Point2D enemyLocation = project(robotLocation, enemyAbsoluteBearing, enemyDistance);
		Point2D robotDestination;

		final double MAX_TRIES = 125;
		final double DEFAULT_EVASION = 1.2;
		final double WALL_BOUNCE_TUNER = 0.699484;
		final double DIR_ANGLE = 0.4;

		Rectangle2D fieldRectangle = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		double tries = 0;
		do{
			robotDestination = project(enemyLocation, enemyAbsoluteBearing + Math.PI + DIR_ANGLE*dir, enemyDistance * (DEFAULT_EVASION - tries / 100.0));
			tries++;
		}
		while (!fieldRectangle.contains(robotDestination) && tries < MAX_TRIES);


		// don't randomly change direction when using stop&go to avoid being hit by head-on targeting
		if((!stopandgo &&  Math.random() < (11 / 0.421075) / enemyDistance) || (tries > (enemyDistance / 11 / WALL_BOUNCE_TUNER))) {
			dir *= -1;
		}

		// Jamougha's cool way
		double turn = absoluteBearing(robotLocation, robotDestination) - getHeadingRadians();

		if(traveldist != 0)
			setAhead(Math.signum(Math.cos(turn))*traveldist);
		setTurnRightRadians(Math.tan(turn));

		
	}

	//When our bullet hits them, they lose energy
	public void onBulletHit(BulletHitEvent e) {
		prevEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}
	//When we get hit by the enemies bullet, they gain energy
	public void onHitByBullet(HitByBulletEvent e) {
		prevEnergy += Rules.getBulletHitBonus(e.getPower());
		timesHit++;
	}
}
