package kinsen.nano;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * Hophlomachy -- A nano robot by Kinsen Choy
 */
public class Hoplomachy extends AdvancedRobot
{
	// Direction is now determined by distance from enemy
//	private static int direction;
	private static int isMoving;
	private static double energyLastPower;

	// These will default to zero
	private static double enemyAverageVelocity;
	private static double averageVelocityCount;

	private static int myHits;

	// This is 500 (adjusted so that turn rate based on 
	private static double distanceFromEnemy;
//	private static final float distanceFromEnemy = 350;

	// (Math.PI / 12) / (8) * (800)
	// Adjust to radians
	// Adjust based on maximum velocity
	// Adjust based on distance
	private static final double ANGLE_ADJUST = 22.907446432425575697123441336413;

	private static final double PERPENDICULAR = Math.PI / 2;

	/**
	 * run: Only spin gun
	 */
	public void run()
	{
/*		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);*/

		// Reset distance and always start moving
		distanceFromEnemy = 500;
//		direction = 400;

		isMoving = 0;

		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	/**
	 * onScannedRobot: Collect data and fire
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		// variable serves as enemy energy; absolute bearing; enemy distance
		double variable;
		// variable2 does not serve as anything
//		double variable2;
		if ((/*variable2 = */energyLastPower - (variable = e.getEnergy()))/* < 5 && variable2 */> 0)
		{
			// if myHits % 2 == 1
			// Always move
			// else
			// Stop and Go
			isMoving = Math.min(myHits % 2 + (1 - isMoving), 1);
		}

		// If enemy has changed direction (or is stopped)
		if (e.getVelocity() / enemyAverageVelocity <= 0)
		{
			enemyAverageVelocity = 0;
			averageVelocityCount = 0;
		}

		// Done in gun turn line
//		enemyAverageVelocity += e.getVelocity();
//		averageVelocityCount++;
		energyLastPower = variable;

		// VARIABLE CHANGE
		// variable becomes absolute bearing
		variable = getHeadingRadians() + e.getBearingRadians();
//		variable2 = e.getDistance();

		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
		// VARIABLE CHANGE WITHIN NEXT LINE
		setTurnGunRightRadians(Utils.normalRelativeAngle(variable - getGunHeadingRadians() +
								(enemyAverageVelocity += e.getVelocity()) / (++averageVelocityCount) *
								Math.sin(e.getHeadingRadians() - variable) / Math.max(variable = e.getDistance(), 250)
								* ANGLE_ADJUST));

		// Ram enemy if it is too close
		// The distance does not need to be precise
		setAhead(distanceFromEnemy * Math.min(variable - 110, isMoving));

		// Distance adjusted in direction,
		setTurnRightRadians(e.getBearingRadians() + PERPENDICULAR - (variable - Math.abs(distanceFromEnemy)) / distanceFromEnemy);

		// Base only on distance
		setFire(640000 / Math.pow(variable, 2) * Math.random());
	}

	public void onHitByBullet(HitByBulletEvent e)
	{
		myHits++;
	}

	public void onHitWall(HitWallEvent e)
	{
		distanceFromEnemy = -0.8333 * distanceFromEnemy;
//		distanceFromEnemy -= 50;
	}

/*	public void onDeath(DeathEvent e)
	{
		onHitByBullet(null);
	}*/
}