/*
 * Created on Sep 9, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.net.Constants;
import davidalves.net.util.RobotState;

/*
 * Splits distance traveled into equally sized segments
 * 
 * @author David Alves
 *
 */
public class SpeedSegmentation extends LinearSegmentation {
	
	public SpeedSegmentation(int segments){
		super(0.0, Constants.SPEED_MAX, false, false, segments);
	}

	protected double getValue(RobotState shooter, RobotState target, double bulletPower) {
		return Math.abs(target.velocity);
	}
	
}
