package com.timothyveletta.states;

import com.timothyveletta.*;

public class AvoidEnemy extends State {
	private double compareDist;
	
	public AvoidEnemy(FuzzyBot obj) {
		super(obj);
	}
	
	@Override
	public void Init() {
		compareDist = (object.battleFieldWidth + object.battleFieldHeight) / 4;
	}

	@Override
	public void Update() {
		super.Update();
		
		ForceVector vec = new ForceVector(object.myX - object.enemyX, object.myY - object.enemyY);
		
		vec.NormaliseVector();
		
		vec.x = vec.x * activationLevel;
		vec.y = vec.y * activationLevel;
		
		object.applyForce(vec);
	}

	@Override
	public void CalculateActivation() {
		activationLevel = 1.0 - (AIControl.nearestEnemyDist / compareDist);
		
		if(activationLevel < 0.0) {
			activationLevel = 0.0;
		}
	}
}
