package xander.core.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BattleStats implements Serializable {

	public static final String COMMON_STAT_KEY = "DfPEdfeWQzfcfckRlFDSo";
	
	private static final long serialVersionUID = 20110928L;
	
	String robotName;    // name of our robot, including version
	private boolean clearStatsOnNewVersion = true;
	Map<String, Map<String, String>> statMap = new HashMap<String, Map<String, String>>();
	
	public boolean isClearStatsOnNewVersion() {
		return clearStatsOnNewVersion;
	}

	public void setClearStatsOnNewVersion(boolean clearStatsOnNewVersion) {
		this.clearStatsOnNewVersion = clearStatsOnNewVersion;
	}

	void clear() {
		statMap.clear();
	}
	
	public Map<String, String> getStatsForRobot(String robotName, boolean create) {
		Map<String, String> robotStats = statMap.get(robotName);
		if (robotStats == null && create) {
			robotStats = new HashMap<String, String>();
			statMap.put(robotName, robotStats);
		} 
		return robotStats;
	}
	
	public Map<String, String> getCommonStats() {
		return getStatsForRobot(COMMON_STAT_KEY, true);
	}
	
	public String getStatForRobot(String robotName, String statName) {
		Map<String, String> robotStats = statMap.get(robotName);
		if (robotStats != null) {
			return robotStats.get(statName);
		} else {
			return null;
		}
	}
	
	public void setStatForRobot(String robotName, String statName, String statValue) {
		Map<String, String> robotStats = statMap.get(robotName);
		if (robotStats == null) {
			robotStats = new HashMap<String, String>();
			statMap.put(robotName, robotStats);
		}
		robotStats.put(statName, statValue);
	}
	
	public void removeStatForRobot(String robotName, String statName) {
		Map<String, String> robotStats = statMap.get(robotName);
		if (robotStats != null) {
			robotStats.remove(statName);
			if (robotStats.size() == 0) {
				statMap.remove(robotName);
			}
		}
	}
	
	public void removeStatsForRobot(String robotName) {
		statMap.remove(robotName);
	}
}
