package lucasslf.wavesurfing.buffer;

import lucasslf.utility.Utils;

public class SegmentedBuffer {

	private double[] segmentedBuffer;
	
	private double weight;
	
	public SegmentedBuffer(double[] segmentedBuffer, double weight) {
		super();
		this.segmentedBuffer = segmentedBuffer;
		this.weight = weight;
	}

	public double[] getSegmentedBuffer() {
		return segmentedBuffer;
	}

		
	public void updateBin(int index, double oldWeight, double newWeight,double newValue){
		for(int x=0;x< segmentedBuffer.length;x++){
		double value = newValue / (((index - x) *(index - x)) + 1.0);
		segmentedBuffer[x]= Utils.rollingAvg(segmentedBuffer[x], value,
				oldWeight, newWeight );
		}
	}
	
	

	public double getWeight() {
		return weight;
	}

	

	public SegmentedBuffer clone() {
		SegmentedBuffer clone = new SegmentedBuffer(segmentedBuffer.clone(), weight);
		return clone;
	}
	
	
}
