package nat.gfx.renderables;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

import nat.gfx.Renderable;
import nat.utils.M;

public class Bot extends Renderable {
	public Point2D botLocation;
	public Color color;
	public Bot(Point2D location, Color darker) {
		this.botLocation = location;
		color = darker;
	}
	@Override
	public void render(Graphics2D g) {
		if (color != null)
			g.setColor(color);
		double ax = botLocation.getX() - 18d;
		double ay = botLocation.getY() - 18d;
		g.drawRect((int)M.round(ax), (int)M.round(ay), 36, 36);
	}

}
