package pl.Utilities;

/*******************************************************************************
 * A class with a few useful constants and methods for use in Robocode angle
 * calculations. All constants and methods are static for ease of use.
 * 
 * Some calculations are taken from various snippets from
 * http://robowiki.net/cgi-bin/robowiki?Hanji/RobocodeUtils
 ******************************************************************************/
public class AngleUtils {
	private final static double PI = Math.PI;
	/**
	 * A constant for 2 * PI. It is the radian value for 360 degrees.
	 */
	public final static double TWO_PI = 2 * PI;
	/**
	 * A constant for PI / 2. It is the radian value for 90 degrees.
	 */
	public final static double HALF_PI = PI / 2.0;

	/**
	 * Calculates the absolute bearing between two points in radians.
	 * 
	 * Credit: This is a tough one...
	 * 
	 * @param p source point
	 * @param q target point
	 * @return the absolute bearing
	 */
	public static double absoluteBearing(java.awt.geom.Point2D.Double p,
			java.awt.geom.Point2D.Double q) {
		return Math.atan2(q.x - p.x, q.y - p.y);
	}

	/**
	 * Normalizes given angle to between 0 and TWO_PI.
	 * 
	 * Credit: Jonathon (not sure)
	 * 
	 * @param angle given angle in radians
	 * @return normalized angle
	 */
	public static double normalizeHeading(double angle) {
		return (angle % TWO_PI + TWO_PI) % TWO_PI;
	}

	/**
	 * Normalizes given angle to between -PI (inclusive) to PI (exclusive).
	 * 
	 * Credit: Jonathon (not sure)
	 * 
	 * @param angle given angle in radians
	 * @return normalized angle
	 */
	public static double normalizeBearing(double angle) {
		return normalizeHeading(angle + PI) - PI;
	}
}