package nz.jdc.nano;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * NeophyteSRAL (segmented rolling average linear)
 * 
 * My first nano bot. Close sibling to NeophytePRAL.
 * Firing: rolling average of linear velocity with linear targeting, segmented 
 *   by velocity.
 * Movement: Bullet dodge. Toggles between uni-directional and reversing moves.
 * 
 * Credits: Pretty much everybody, especially those who contributed helpful articles to the
 * wiki, particularly the stuff on flat movement, rolling averages and nano-linear targetting.
 * Movement is based on the very elegant movement strategy of dft.Freddie 1.32 by Alcatraz271.
 * Updates and code size improvements from perusing rectent top bots like little black book,
 * Yatagan etc, so credit to Skilgannon, Sheldor, Michael Dorgan any anybody else whose code 
 * I have perused and forgotten to credit.
 *  
 * Version 1.0: Initial version. Hopefully not too sucky. Unfortunately testing shows it is
 *   weak against the plethora of pattern gun / random movement bots out there.
 *   Codesize 249.
 *   
 * Version 1.1: A lot of fine tuning. Altered most of the tunable factors. Improved the
 *   segmenting function. Altered the energy management.
 *   Unfortunately has shown a distinct weakness against ocsillating movement, but that is 
 *   inherent in the gun design and cannot fix in nano-size.  
 *
 * Version 1.2: change movement to one derived from dft.Freddie by Alcatraz271.
 *   Codesize 245.
 *   
 * Version 1.3 : saved a few bytes, added bullet vel and different averaged segmentation. 
 *   Codesize 248.  
 *
 * @author John Cleland
 */
public class NeophyteSRAL extends AdvancedRobot {
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 245.0;
  private final static double NON_RAND            = 0.16;
  private final static double PREFERRED_RANGE     = 220.0;
  private final static double CLOSE_FCT           = 477 * MOVE_DISTANCE;
  
  // for gun
  private final static double BULLET_POWER_FACTOR = 450.0D;
  private final static double ROLL_FACTOR         = 9;
  private final static double SEG_ROLL_FACTOR     = 11.0;
  private final static int    V_OFFS              = 8;
  private final static int    V_BINS              = 1 + 2 * V_OFFS;
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir             = MOVE_DISTANCE;
  private static double       moveMode            = 1;
  
  // for gun  
  private static double[]     rAvgLateralVelocity = new double[V_BINS];
  private static double       rAvgCurrent;

  
  /**
   * Bot run method.
   */
  public void run() {
    // testparam = Double.parseDouble(System.getProperty("RUMBLETESTER_PARAM"));
    
    // helps targeting accuracy
    setAdjustGunForRobotTurn(true);

    // start our infinite radar loop
    turnRadarRightRadians(Double.POSITIVE_INFINITY);
  }
  
  /**
   * Scan handler.
   * This is where it all happens.
   */
  public void onScannedRobot(ScannedRobotEvent e) {
    // register vars, should be the most commonly used
    int    lvIndex;
    double rd;

    // other vars
    double latVel;
    
    // radar scan
    setTurnRadarLeftRadians(getRadarTurnRemaining());
    
    // bullet dodge a random distance
    if ( (char) ((enemyEnergy - 1 - (enemyEnergy = e.getEnergy()))) <= 2) {
      setAhead((moveDir *= moveMode) * (Math.random() + NON_RAND));
    }
    
    // turn perpendicular with range control
    setTurnRightRadians(Math.cos((rd = e.getBearingRadians()) - (e.getDistance() - PREFERRED_RANGE) * moveDir / CLOSE_FCT));
    // rd has enemy relative bearing

    lvIndex = V_OFFS + (int) (rAvgCurrent = (rAvgCurrent * SEG_ROLL_FACTOR + (latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - (rd +=  getHeadingRadians())))) / (SEG_ROLL_FACTOR + 1));
    // rd now has enemy absolute bearing

    rAvgLateralVelocity[lvIndex] = (rAvgLateralVelocity[lvIndex] * ROLL_FACTOR + latVel) / (ROLL_FACTOR + 1);
    setTurnGunRightRadians(Utils.normalRelativeAngle(rd  - getGunHeadingRadians() 
      + ( rAvgLateralVelocity[V_OFFS + (int) latVel] / Rules.getBulletSpeed(rd = /*Math.min(getEnergy() - 4,*/ BULLET_POWER_FACTOR / e.getDistance()))));
    
    // fire
    setFire(rd);
  }
  
  /**
   * Hit a wall, reverse direction and start moving immediately.
   */
  public void onHitWall(HitWallEvent e) {
    setAhead(moveDir = -moveDir);
  }

  /**
   * Hit by bullet, change movement strategy.
   */
  public void onHitByBullet(HitByBulletEvent e) {
    moveMode = -moveMode;
  }
}
