package simonton.nano;

import java.awt.*;

import robocode.*;
import robocode.util.*;

/**
 * This little guy is my entrance into the Melee world. He was inspired by
 * DuelistNanoMelee! I used its movement and varied how far from the corner the
 * bot travels based on the distance to the enemy. I tweaked the ratio to be as
 * far from the corner as possible, to avoid head-on-targeting, but still change
 * directions often enough to avoid linear targeting.
 * 
 * Version 1.0: + 242 bytes (with 3 colors).
 * 
 * Version 1.1: + Squeezed codesize. + The gun is now more linear as the enemy
 * gets closer. + Energy management user getOthers() and getDistance() now, too,
 * not just getEnergy(). + 249 bytes (with 1 color).
 * 
 * Version 1.2: + Back to 1.0 (thought I was doing more than than, oops!) + 214
 * bytes (no colors).
 * 
 * Version 1.3: + Spin the radar after every shot. + 220 bytes (no colors).
 * 
 * Version 1.4: + Revert to 1.2. + Try adding some randomness to the movement. +
 * 223 bytes (no colors).
 * 
 * Version 1.5: + Revert to 1.2. + Try releasing our radar lock to find bots we
 * ram. + 217 bytes (no colors).
 * 
 * Version 1.5.2: + Try a perhaps better way to not just release the radar lock,
 * but force it onto the ramming bot?
 * 
 * Version 1.6: + Try out 1.1's enegy management. + 236 bytes (no colors).
 * 
 * Version 1.6.2 + Use normalRelativeAngle in the gun, instead of sin. + 236
 * bytes (no colors).
 * 
 * Version 1.7 + revert to 1.6. + Always fire at power 3.0 when in a ram. + 248
 * bytes (no colors).
 * 
 * Version 1.8 + revert to 1.6. + Only fire if I have more than 3 energy. + 248
 * bytes (no colors).
 */
public class MeleeSeed extends AdvancedRobot {

	private static final int WALL_MARGIN = 18;
	private static final int BATTLEFIELD_WIDTH = 1000;
	private static final int BATTLEFIELD_HEIGHT = 1000;

	static int side;
	static int distance;

	public void run() {

		// setColors(Color.WHITE, Color.GREEN, Color.WHITE);

		// Robot death events should be processed AFTER robot hit events, but
		// still before scan events.
		setEventPriority("RobotDeathEvent", 15);

		// setAdjustGunForRobotTurn(true);
		setTurnRadarRightRadians(side = distance = Integer.MAX_VALUE - 1000);
	}

	public void onScannedRobot(ScannedRobotEvent r2e) {

		int r3i;
		int r4i;
		double a;

		// only lock the radar & aim if this scan is from our target.
		r3i = WALL_MARGIN + (int) r2e.getDistance() / 3;
		if (r3i < distance + 40) {
			distance = r3i;

			// standard infinity lock
			setTurnRadarLeft(getRadarTurnRemaining());

			// head-on targeting
			setTurnGunRightRadians(Math.sin(r2e.getBearingRadians()
				+ getHeadingRadians()
				- getGunHeadingRadians()));
			// + r2e.getVelocity()
			// * Math.sin(r2e.getHeadingRadians() - a)
			// / Math.pow(r3i, 20)));
		}

		// setFire(getEnergy() / 16);
		if (getEnergy() > 3) {
			setFire(5 * getOthers() * getEnergy() / r3i);
		}

		// when we reach our destination, go to the other one! This also gives
		// us a little variability when running into other bots ... which in
		// a few rare cases will break us free from the ram.
		r4i = WALL_MARGIN;
		if (getDistanceRemaining() == 0) {
			side = -side;
		}
		if (side > 0) {
			r4i = r3i;
			r3i = WALL_MARGIN;
		}

		// translate our destination to the nearest corner
		if (getY() > BATTLEFIELD_HEIGHT / 2) {
			r3i = BATTLEFIELD_HEIGHT - r3i;
		}
		if (getX() > BATTLEFIELD_WIDTH / 2) {
			r4i = BATTLEFIELD_WIDTH - r4i;
		}

		// goto code this small is thanks to a trick inspired by ChaseSan
		setTurnRightRadians(Math.tan(a =
			Math.atan2(r4i -= (int) getX(), r3i -= (int) getY())
				- getHeadingRadians()));
		setAhead(Math.cos(a) * Math.hypot(r4i, r3i));
		execute();
	}

	public void onRobotDeath(RobotDeathEvent e) {

		// when a robot dies, it could have been our target, so make sure we can
		// pick a new one in that case, instead of skipping our gun-turn code.
		// Credit goes to Graviton for this idea.
		distance = Integer.MAX_VALUE - 1000;
	}

	public void onHitRobot(HitRobotEvent e) {

		distance = 18 + 40 / 3;
	}
}
