package axeBots;
import java.awt.geom.*;

/** Classe para tratamentos de vetores para o robocode orientaccao com 0 graus para cima na tela (eixo y).
 * @author Marcos Machado Coelho de Souza  
 */
class AxeVector implements Cloneable {
    //private double teta;
    //private double modulo;
    private double x;
    private double y;

    private double x0;
    private double y0;

    private double dx;
    private double dy;

    //private double y1;
    //private double y2;
    //private double dy;
    //private double dx;
    //private double modulo;

    /** constroi um vetor com centro 0,0 e fim x1,y1.
     */
    public AxeVector(double x1, double y1) {
        this.x= x1;
        this.y= y1;
        x0= 0;
        y0= 0;
        dx= x - x0;
        dy= y - y0;
        //head = normalAbsoluteAngle(head);
    }
    /** constroi um vetor com centro x1,y1, angulo theta (graus), e modulo mod
     */
    public AxeVector(double x1, double y1, double theta, double mod) {
        x0= x1;
        y0= y1;
        theta= Math.toRadians(RoboMath.normalAbsoluteAngle(theta));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x1 + x2;
        this.y= y1 + y2;
        dx= x - x0;
        dy= y - y0;
    }

    /** constroi um vetor com inicio em p1 e fim em p2
    	 */
    public AxeVector(Point2D.Double p1, Point2D.Double p2) {
        x= p2.getX();
        y= p2.getY();
        x0= p1.getX();
        y0= p1.getY();
        dx= x - x0;
        dy= y - y0;

    }

    public String toString() {
        return "("
            + x0
            + ","
            + y0
            + ")("
            + x
            + ","
            + y
            + ") theta:"
            + this.getRelativeTheta()
            + " mod:"
            + this.getRelativeModule()
            + " dx:"
            + dx
            + " dy:"
            + dy;
    }

    public double getX() {
        return x;
    }
    public double getY() {
        return y;
    }

    public double getDX() {
        return dx;
    }
    public double getDY() {
        return dy;
    }

    public double getX0() {
        return x0;
    }
    public double getY0() {
        return y0;
    }

    public Point2D.Double getStartPoint() {
        return new Point2D.Double(x0, y0);
    }

    public Point2D.Double getEndPoint() {
        return new Point2D.Double(x, y);
    }

    public void setModule(double mod) {
        /*
         x0= x1;
        y0= y1;
        theta= Math.toRadians(RoboMath.normalAbsoluteAngle(theta));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x1 + x2;
        this.y= y1 + y2;
        dx= x - x0;
        dy= y - y0;
         */

        double theta=
            Math.toRadians(RoboMath.normalAbsoluteAngle(getRelativeTheta()));
        double x2= mod * Math.sin(theta);
        double y2= mod * Math.cos(theta);
        this.x= x0 + x2;
        this.y= y0 + y2;
        dx= x - x0;
        dy= y - y0;
    }

    public double getModule() {
        return Math.sqrt(x * x + y * y);
    }

    public double getTheta() {
        return Math.toDegrees(Math.PI / 2 - Math.atan2(y, x));
    }
    /** seta nova origem mantendo pt final. theta e modulo mudam!!
     */
    public void setOrigin(double x1, double y1) {
        x0= x1;
        y0= y1;
        dx= x - x0;
        dy= y - y0;
    }

    /** retorna o modulo do vetor
     */
    public double getRelativeModule() {
        return Math.sqrt(dx * dx + dy * dy);
    }

    /** retorna o angulo do vetor em graus.
     */
    public double getRelativeTheta() {
        return Math.toDegrees(Math.PI / 2 - Math.atan2(dy, dx));
    }

    public AxeVector minus(AxeVector vec) {
        AxeVector vecInv = (AxeVector)vec.clone();
        vecInv.setModule(vecInv.getModule()*(-1));
        return this.plus(vecInv);
     
    }

    public AxeVector plus(AxeVector vec) {
        AxeVector ret;

        Point2D.Double p0= this.getStartPoint();
        double retDx= this.getDX() + vec.getDX();
        double retDy= this.getDY() + vec.getDY();
        Point2D.Double pF=
            new Point2D.Double(p0.getX() + retDx, p0.getY() + retDy);
        ret= new AxeVector(p0, pF);
        
        return ret;
    }

    public void relativePlus(AxeVector vec) {

        dx= dx + vec.getDX();
        dy= dy + vec.getDY();
        x= x0 + dx;
        y= y0 + dy;
    }

    /*
    public AxeVector div(double d)
    {
    	AxeVector ret;
    	ret = new AxeVector((this.getX()+vec.getX()),(this.getY()+vec.getY()));
    	return ret;
    }*/

    public double getRelativeModule(double x1, double y1) {
        double Dx= x - x1;
        double Dy= y - y1;
        return Math.sqrt(Dx * Dx + Dy * Dy);
    }

    public double getRelativeTheta(double x1, double y1) {
        double Dx= x - x1;
        double Dy= y - y1;
        return Math.toDegrees(Math.PI / 2 - Math.atan2(Dy, Dx)); //Dx,Dy));
    }

    public Object clone() {
        Object ret= null;
        try {
            ret= super.clone();

        } catch (CloneNotSupportedException e) {
            ret= null;
            HataMoto.getIt().out.println("************** nao cloneou:"+this);
        }
        return ret;
    }

}