package maribo.mini;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class MiniQuester extends AdvancedRobot {
	static final int numEn = 9;
	static final double PI = Math.PI;
	static int curNumEn;
	static final int distFact = 350;
	static final int distSeg = (1400/distFact)+1;
	
	static HashMap<String, Enemy> en = new HashMap<String, Enemy>();
	static Enemy targ;
	static String targName;
	static Enemy myRobo;
	
	static Point2D.Double nextDestination;
	static Point2D.Double lastPos;
	static final Rectangle2D.Double moveField = new Rectangle2D.Double(30, 30, 940, 940);
	
	static CircularGun circular = new CircularGun();
	static HeadOnGun headOn = new HeadOnGun();
	
	static final Rectangle2D.Double board = new Rectangle2D.Double(17.9, 17.9, 964.2, 964.2);
	static ArrayList<VirtualBullet> virtualBullets = new ArrayList<VirtualBullet>();
	
	public void run() {
		virtualBullets.clear();
		targName = "";
		myRobo = new Enemy();
		targ = new Enemy();
		
		nextDestination = lastPos = new Point2D.Double(getX(), getY());

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		while (true) {
			curNumEn = getOthers();
			myRobo.setLocation(calcPos(new Point2D.Double(getX(), getY()), (myRobo.velocity = getVelocity()), (myRobo.heading = getHeadingRadians())));
			if (getRadarTurnRemainingRadians() == 0) setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			moveVB();
			if (targ.x != 100000) gun();
			if (!en.isEmpty()) movement();
			execute();
		}
	}
	
	public void moveVB() {
		Iterator<VirtualBullet> i = virtualBullets.iterator();
		while (i.hasNext()) {
			VirtualBullet vb = (VirtualBullet) i.next();
			vb.setLocation(calcPos(vb, vb.velocity, vb.heading));
			Iterator<Enemy> enIt = en.values().iterator();
			while (enIt.hasNext()) {
				Enemy nEn = (Enemy) enIt.next();
				if (new Rectangle((int)nEn.x-18, (int)nEn.y-18, 36, 36).contains(vb)) {
					try {
						vb.gunUsed.hits[getOthers()/3][(int) (targ.distance(myRobo)/distFact)]++;
						i.remove();
					} catch (Exception ex) { }
				}
			}
		}
	}
	
	public void gun() {
		double dist = targ.distance(myRobo);
		
		Gun bestGun = (circular.hits[getOthers()/3][(int) (dist/distFact)]
					> headOn.hits[getOthers()/3][(int) (dist/distFact)]) ? circular : headOn;
		
		double bulletPower;
		setTurnGunRightRadians(Utils.normalRelativeAngle(
				bestGun.getFiringAngle(myRobo, targ, (bulletPower = Math.min(2.4999, (600+90*(getOthers()-1))/dist)))
				- getGunHeadingRadians()));
		
		Bullet b = setFireBullet(bulletPower);
		if (b != null) {
			addBullet(circular, bulletPower);
			addBullet(headOn, bulletPower);
		}
	}
	
	public void addBullet(Gun gun, double bulletPower) {
		VirtualBullet newVirtualBullet = new VirtualBullet();
		newVirtualBullet.setLocation(calcPos(myRobo,
				(newVirtualBullet.velocity = Rules.getBulletSpeed(bulletPower)),
				(newVirtualBullet.heading = gun.getFiringAngle(myRobo, targ, bulletPower))));
		newVirtualBullet.gunUsed = gun;
		virtualBullets.add(newVirtualBullet);
	}
	
	public void movement() {
		double distanceToNextDestination;
		if ((distanceToNextDestination = myRobo.distance(nextDestination)) < 15) {
			Point2D.Double testPoint;
			int enMult = numEn-curNumEn;
			int i = 0;
			do {
				testPoint = calcPos(myRobo, (192-(16*enMult))+(Math.random()*32*enMult), i*PI/50.0);
				if (moveField.contains(testPoint)) {
					if (evaluate(testPoint) < evaluate(nextDestination)) {
						nextDestination = testPoint;
					}
				}
			} while (i++ < 160*(numEn+1)/(curNumEn+1));
			lastPos = new Point2D.Double(myRobo.x, myRobo.y);
		} else {
			double angle = Utils.normalRelativeAngle(calcAngle(nextDestination, myRobo) - getHeadingRadians());
			double turnAngle = Math.atan(Math.tan(angle));
			setTurnRightRadians(turnAngle);
			setAhead(distanceToNextDestination * (angle == turnAngle ? 1 : -1));
			setMaxVelocity(Math.abs(turnAngle) > 0.785 ? 2 : 8d);
		}
	}
	
	public double evaluate(Point2D.Double test) {
		double danger = 0;
		Iterator<Enemy> enIt = en.values().iterator();
		while (enIt.hasNext()) {
			Enemy nEn = (Enemy) enIt.next();
			double enDang = 0;
			enDang += (nEn.energy+30)
					* (1+Math.abs(Math.cos(calcAngle(myRobo, test) - calcAngle(nEn, test))))
					/ Math.pow(nEn.distance(test), 2-((curNumEn-1)/3)/2.0);
			int numClose = 0;
			Iterator<Enemy> enIt2 = en.values().iterator();
			while (enIt2.hasNext()) {
				if (enIt2.next().distance(nEn) < nEn.distance(myRobo)) numClose++;
			}
			if (numClose < 3) enDang *= 2;
			danger += enDang;
		}
		danger += (1+10*(curNumEn-1))/test.distanceSq(lastPos);
		return danger;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		String enName = e.getName();
		Enemy temp;
		temp = (en.containsKey(enName)) ? en.get(enName) : new Enemy();
		temp.updateAll(calcPos(myRobo, e.getDistance(), getHeadingRadians() + e.getBearingRadians()),
				e.getHeadingRadians(), e.getVelocity(), e.getTime(), e.getEnergy());
		en.put(enName, temp);
		
		if (temp.distance(myRobo) < targ.distance(myRobo)*.85) {
			targ = en.get(enName);
			targName = e.getName();
		}
		if (getGunHeat() < 0.7 || getOthers() < 2) {
			setTurnRadarRightRadians(2.1*Utils.normalRelativeAngle(calcAngle(targ, myRobo)-getRadarHeadingRadians()));
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		en.remove(e.getName());
		targ.setLocation(100000, 100000);
	}
	
	public static Point2D.Double calcPos(Point2D.Double loc, double distance, double bearing) {
		return new Point2D.Double(loc.x + distance * Math.sin(bearing), loc.y + distance * Math.cos(bearing));
	}
	
	public static double calcAngle(Point2D.Double p2, Point2D.Double p1){
		return Math.atan2(p2.x - p1.x, p2.y - p1.y);
	}
}