package simonton.core;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import robocode.Event;
import simonton.guns.Gun;
import simonton.movements.*;
import simonton.utils.*;

public class OneOnOneBot extends AdvancedRobot implements Bot {

	protected static Gun gun;
	protected static Movement movement;
	private static double skippedTurns;
	private static double damage;
	private BotConduit gunConduit;
	private BotConduit movementConduit;

	private ScannedRobotEvent scan;
	private BulletHitBulletEvent cross;
	private BulletHitEvent hit;
	private HitByBulletEvent burn;
	private Bullet bullet;
	private HitWallEvent bang;

	private Wave nextEnemyWave;
	private double enemyEnergy;
	private double energy;

	protected Gun getGun() {

		return null;
	}

	protected Movement getMovement() {

		return null;
	}

	protected double getNextBulletPower() {

		return 3;
	}

	@Override
	public void run() {

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		Util.startRound(this);
		if (gun == null) {
			gun = getGun();
		}
		if (movement == null) {
			movement = getMovement();
		}
		if (gun != null) {
			gun.run();
			gunConduit = new BotConduit(this, gun);
			gunConduit.syncBot();
		}
		if (movement != null) {
			movement.run();
			movementConduit = new BotConduit(this, movement);
			movementConduit.syncBot();
		}

		do {
			Util.startTurn(this);

			// fire.
			if (gun != null) {
				bullet = null;
				if (getGunTurnRemaining() == 0) {
					bullet = setFireBullet(gun.getNextBulletPower());
					if (bullet != null) {
						Wave wave = new Wave(gun);
						Util.myWaves.add(wave);
					}
				}
			}

			// housekeeping
			if (scan == null) {
				setTurnRadarRightRadians(1);
			} else {
				Util.enemyP = Util.project(Util.myP, scan.getDistance(), scan
						.getBearingRadians()
						+ getHeadingRadians());

				// turn radar
				setTurnRadarRightRadians(Util.normalize(getHeadingRadians()
						+ scan.getBearingRadians() - getRadarHeadingRadians()));

				// fire enemy waves
				double energy = scan.getEnergy();
				double drop = enemyEnergy - energy;
				enemyEnergy = energy;
				if (drop < 3.01 && drop > 0.09) {
					nextEnemyWave.setBulletPower(drop);
					Util.enemyWaves.add(nextEnemyWave);
					Util.addedEnemyWave = nextEnemyWave;
				}
				nextEnemyWave = new Wave(Util.enemyP, Util.myP, Util.time);

				// trim waves
				Iterator<Wave> it = Util.enemyWaves.iterator();
				if (it.hasNext()) {
					Wave wave = it.next();
					if (wave.impactTime(Util.myP) + 3 < Util.time) {
						it.remove();
						Util.deletedEnemyWave = wave;
					}
				}
				if (gun != null) {
					it = Util.myWaves.iterator();
					if (it.hasNext()
							&& it.next().impactTime(Util.enemyP) + 3 < Util.time) {
						it.remove();
					}
				}
			}

			// aim.
			if (gun != null) {
				gun.setBullet(bullet);
				gunConduit.syncBot();
				gun.setNextBulletPower(getNextBulletPower());
				sync(gun);
				setTurnGunRightRadians(gun.getGunTurnRemainingRadians());
			}

			// run.
			if (movement != null) {
				movementConduit.syncBot();
				sync(movement);
				setTurnRightRadians(movement.getTurnRemainingRadians());
				setAhead(movement.getDistanceRemaining());
				// if (burn != null) {
				// movement.onBulletHit(new BulletHitEvent(getName(),
				// getEnergy(), burn.getBullet()));
				// }
				// if (hit != null) {
				// movement.onHitByBullet(new HitByBulletEvent(0, hit
				// .getBullet()));
				// }
				// if (cross != null) {
				// movement.onBulletHitBullet(new BulletHitBulletEvent(cross
				// .getHitBullet(), cross.getBullet()));
				// }
				// }
			}

			scan = null;
			cross = null;
			hit = null;
			burn = null;
			scan();
		} while (true);
	}

	private void sync(SlaveBot bot) {
		if (burn != null) {
			bot.onHitByBullet(burn);
		}
		if (hit != null) {
			bot.onBulletHit(hit);
		}
		if (cross != null) {
			bot.onBulletHitBullet(cross);
		}
		if (bang != null) {
			bot.onHitWall(bang);
		}
		if (scan != null) {
			bot.onScannedRobot(scan);
		}
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {

		scan = e;
		energy = getEnergy();
	}

	@Override
	public void onBulletHitBullet(BulletHitBulletEvent e) {

		cross = e;
	}

	@Override
	public void onHitByBullet(HitByBulletEvent e) {

		enemyEnergy += 3 * e.getPower();
		burn = e;
		damage += Util.getBulletDamage(e.getPower());
	}

	@Override
	public void onBulletHit(BulletHitEvent e) {

		enemyEnergy -= Util.getBulletDamage(e.getBullet().getPower());
		hit = e;
	}

	@Override
	public void onHitWall(HitWallEvent e) {

		bang = e;
	}

	@Override
	public void onSkippedTurn(SkippedTurnEvent e) {

		Util.log("Skipped Turn! (@" + getTime() + ")");
		++skippedTurns;
	}

	@Override
	public void onDeath(DeathEvent e) {

		if (gun != null) {
			gun.onDeath(e);
		}
		for (Event event : (Vector<Event>) getAllEvents()) {
			if (event instanceof HitByBulletEvent) {
				damage += energy;
			}
		}
		endRound();
	}

	@Override
	public void onWin(WinEvent e) {

		if (gun != null) {
			gun.onWin(e);
		}
		endRound();
	}

	@Override
	public void onPaint(Graphics2D g) {

		// int time = (int) getTime();
		// boolean hit = false;
		// for (Wave wave : Util.waves) {
		// wave.onPaint(g, time);
		// if (wave.isHit(enemyP, time)) {
		// hit = true;
		// }
		// }
		// g.setColor(Color.RED);
		// if (hit) {
		// g.fillRect((int) enemyP.x - 18, (int) enemyP.y - 18, 36, 36);
		// } else {
		// g.drawRect((int) enemyP.x - 18, (int) enemyP.y - 18, 36, 36);
		// }
		if (gun != null) {
			// Wave.getNextShot(gun).onPaint(g, time);
			gun.onPaint(g);
		}
		if (movement != null) {
			movement.onPaint(g);
		}
	}

	private void endRound() {

		System.out.println(skippedTurns + " skipped turns");
		if (getRoundNum() + 1 == getNumRounds()) {
			gun = null;
			gunConduit = null;
		}
		  double percent = damage / (getRoundNum() + 1);
		  System.out.println("Damage: " + damage
		  + " (" + percent + "/" + (100 - percent) + ")");
	}
}
