package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cGunLinear {
	private Cake oRobot = null;
	private cGunControl oGunControl = null;
	private cComControl oComControl = null;
	
	public cGunLinear(Cake pRobot, cGunControl pGunControl, cComControl pComControl) {
		oRobot = pRobot;
		oGunControl = pGunControl;
		oComControl = pComControl;
	}
	
	public void doInit() {
	}
	
	public void doUnInit() {
	}
	
	public void doTurn() {
		double pBulletPower = oGunControl.mGunPower.getPower();
		double pEnemyRelativeHeading = oComControl.mComEnemy.mEnemyHeading[oComControl.mTarget] - oComControl.mComEnemy.mEnemyDirection[oComControl.mTarget];
		double pBulletVelocity = 20 - (3 * pBulletPower);
		double pGunOffset = Math.toDegrees(Math.asin((oComControl.mComEnemy.mEnemyAvgVelocity[oComControl.mTarget] * Math.sin(Math.toRadians(pEnemyRelativeHeading))) / pBulletVelocity));
		//Debugging:
		//oRobot.out.println("Enemy Relative Heading: " + pEnemyRelativeHeading);
		//oRobot.out.println("Bullet Power: " + pBulletPower + "  Bullet Velocity: " + pBulletVelocity);
		//oRobot.out.println("Lead Offset: " + pGunOffset);
		oRobot.setTurnGunRight(oRobot.normalRelativeAngle(oComControl.mComEnemy.mEnemyDirection[oComControl.mTarget] - oRobot.getGunHeading()) + pGunOffset);
		
		
		if (oRobot.getGunHeat() == 0) oComControl.doComFire(pBulletPower);
	}
	
	public void onBulletHit(BulletHitEvent e) {
	}
}