package ers.nano.sunderer;

/**
 * Author: ER Samson
 * 
 * This design has evolved to
 * 		• Averages (current and firing Velocities) Gun
 * 		• Multi-Mode Movement
 * 			• One- and Two-Way Oscillator Movement
 * 			• Staying perpendicular to the enemy
 * 			• Ram!
 * 
 *  -- Credits to the following --
 * Heavy influence coming from both Yatagan and NeophytePRAL as their multi-mode
 * movement really crushes this robot. I also like the idea of ButtHead and Sabreur.
 * Goal now is to create a bot without look-up tables since I'm too dumb to use it.
 * Carried iterations from LigMA and hopefully Sunderer is more competitive.
 * 
 * Movement:
 * 		• Mark Whiteley      - http://mark.random-article.com/robocode/improved_movement.html
 * 		• Wiki               - https://robowiki.net/wiki/User:Exauge/snippets
 *		• Wiki               - https://robowiki.net/wiki/Stop_And_Go_Tutorial
 * 		• Wiki               - https://robowiki.net/wiki/Oscillator_Movement
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 *		• Sheldor			 - https://robowiki.net/wiki/Sabreur
 * 
 * Radar:
 * 		• Wiki               - https://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targeting:
 * 		• Wiki               - https://robowiki.net/wiki/Rolling_Averages
 *		• Exauge             - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Sheldor            - https://robowiki.net/wiki/Foilist
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 		• Sheldor			 - https://robowiki.net/wiki/Sabreur
 * 
 * Code Shrinking Tips:
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;

public class Sunderer extends AdvancedRobot {

	// ---------- FINAL ----------	
	private static final int	BULLET_POWER	= 2;
	private static final int    BULLET_VELOCITY	= (int)(20 - 3 * BULLET_POWER);
	private static final int	ANTIRAM_FACTOR	= 103;
	private static final int	ORBIT_DISTANCE	= 160; // Testing between 130-220
	private static final int	DISTANCE_FACTOR	= 30000;
	private static final int	DEATH_FACTOR	= 3; // Testing between 3-5
	private static final int	ROUND_LIMIT		= 11; // Testing between 11-13

	// ---------- Generic Variables ----------
	private static double 		enemyHealth;
	private static double		fireVel;
	private static double		moveDistance	= ANTIRAM_FACTOR;
	private static int			deathCount;

	public void run() {
		// Color Identification
		//setColors(Color.darkGray, Color.black, Color.orange); // Saving 13 code size!

		// Easy targeting and infinite radar movement
		setAdjustGunForRobotTurn(true); // Saving 5 code size!
	    setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		
		// ---------- Generic Variables ----------	
		double absoluteBearing;
		double bearing;
		double lead;
		
		// ---------- Musashi Movement Logic ----------				
		setTurnRightRadians(Math.cos( (absoluteBearing = 
				(bearing = e.getBearingRadians())) + 
				((ORBIT_DISTANCE - e.getDistance()) * 
				(moveDistance / DISTANCE_FACTOR)))); 
				// Idea from Sheldor and Skilgannon's Yatagan

		// ---------- Gun Logic ----------
		// Averages current and velocity of opponent at max "gun heat"
		// Aim. Ignore own bullet power/speed
		setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing += 
				getHeadingRadians()) - getGunHeadingRadians() + 
				(lead = (((e.getVelocity() + fireVel) / 2) * 
				Math.sin(e.getHeadingRadians() -
				absoluteBearing) / BULLET_VELOCITY))));

		// Fire at enemy! Has Anti-Ram/Ramming bullet power change
		if (setFireBullet(BULLET_POWER + (int)(ANTIRAM_FACTOR / 
				e.getDistance())) != null) {
			fireVel = e.getVelocity(); // Try to hit those quick oscillators!
		}
		
		// ---------- Energy Drop Logic ----------
		// Multi-mode oscillation switch idea from Sheldon's Sabreur
		// If logic from idea from John Cleland's NeophytePRAL
		setAhead(moveDistance);
		if ((char)(enemyHealth - 1 - (enemyHealth = e.getEnergy())) < 4 
				&& (deathCount % 2) != 0) {
			onHitWall(null);
		}

		// If died more than DEATH_FACTOR times in the first ROUND_LIMIT
		// Switch to ramming the enemy.
		// Multi-mode Ram idea from Sheldon's Sabreur
		if (deathCount > DEATH_FACTOR) {
			fireVel = e.getVelocity();
			setTurnRightRadians(Math.tan(bearing + lead));
			setAhead(Math.cos(bearing) / 0);
		}

		// ---------- Radar Logic ---------- 
		// From RoboWiki
		setTurnRadarLeft(getRadarTurnRemaining());	
	}

	/**
	 * Change movement on Wall Hit
	 */
	public void onHitWall(HitWallEvent e) {
		moveDistance = -moveDistance;
	}

	/**
	 * Switches 1-2 Way Oscillation to Ramming movement
	 */
	public void onDeath(DeathEvent e) {
		// Increment the deathCount variable.
		// Multi-mode Ram idea from Sheldon's Sabreur
		if (getRoundNum() < ROUND_LIMIT) {
			deathCount++;
		}
	}	
}