/*
 * Decompiled with CFR 0.152.
 */
package rdt.Waves;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotDataSnapshot;
import rdt.VirtualGuns.VirtualGunFiringData;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;
import rdt.Waves.WaveDataPool;
import rdt.Waves.WaveDataUtils;
import rdt.Waves.WaveGeneratedListener;
import rdt.Waves.WaveRemovedListener;
import rdt.Waves.WaveTargetInterface;
import rdt.Waves.WaveTargetListener;

public class WaveManager {
    protected WaveDataPool _pool = null;
    protected ArrayList<WaveTargetListener> _targetListeners = null;
    protected ArrayList<WaveGeneratedListener> _generatedListener = null;
    protected ArrayList<WaveRemovedListener> _removedListeners = null;
    protected ArrayList<WaveData> _activeWaves = new ArrayList();
    protected WaveTargetInterface _targetInterface = null;
    private Color _debugColour;

    public WaveManager(WaveTargetInterface targetInterface, int poolSize, Color debugColour) {
        this._pool = new WaveDataPool(poolSize, this);
        this._targetListeners = new ArrayList();
        this._generatedListener = new ArrayList();
        this._removedListeners = new ArrayList();
        this._targetInterface = targetInterface;
        this._debugColour = debugColour;
    }

    public void ClearWaves() {
        int activeWaves = this._activeWaves.size();
        int index = 0;
        while (index < activeWaves) {
            this._pool.ReturnToPool(this._activeWaves.get(index));
            ++index;
        }
        this._activeWaves.clear();
    }

    public void Update() {
        RobotDataSnapshot targetDataSnapshot = this._targetInterface.GetLatestTargetDataSnapshot();
        int activeWaves = this._activeWaves.size();
        long currentTick = AgentSmith.Instance().getTime();
        int index = 0;
        while (index < activeWaves) {
            int listener;
            WaveData wave = this._activeWaves.get(index);
            double waveDistance = WaveDataUtils.GetWaveDistance(wave, currentTick);
            boolean removeWave = false;
            if (!wave.PassedTarget && waveDistance * waveDistance > WaveDataUtils.GetWaveDistanceSqToSnapshot(wave, targetDataSnapshot)) {
                wave.PassedTarget = true;
                listener = 0;
                while (listener < this._targetListeners.size()) {
                    WaveTargetListener targetListener = this._targetListeners.get(listener);
                    if (targetListener != null) {
                        targetListener.OnPassedTarget(wave, targetDataSnapshot.LocationX, targetDataSnapshot.LocationY);
                    }
                    ++listener;
                }
            } else if (this.CheckWaveShouldBeRemoved(wave)) {
                removeWave = true;
            }
            if (removeWave) {
                listener = 0;
                while (listener < this._removedListeners.size()) {
                    WaveRemovedListener removedListener = this._removedListeners.get(listener);
                    if (removedListener != null) {
                        removedListener.OnWaveRemoved(wave, targetDataSnapshot.LocationX, targetDataSnapshot.LocationY);
                    }
                    ++listener;
                }
                this._pool.ReturnToPool(wave);
                this._activeWaves.remove(wave);
                --index;
                --activeWaves;
            }
            ++index;
        }
    }

    public void AddWave(VirtualGunsFiringData firingData, WaveData.eWaveType type) {
        WaveData newWave = this._pool.TakeFromPool();
        newWave.WaveType = type;
        newWave.VirtualGunData = firingData;
        newWave.OriginX = firingData.FiringLocationX;
        newWave.OriginY = firingData.FiringLocationY;
        WaveDataUtils.SetInitialWaveData(newWave);
        int gunIndex = 0;
        while (gunIndex < firingData.GunFiringData.size()) {
            VirtualGunFiringData gunData = firingData.GunFiringData.get(gunIndex);
            int firingAngleIndex = 0;
            while (firingAngleIndex < gunData.FiringAbsoluteAngles.size()) {
                WaveDataUtils.AddAngle(newWave, gunData.FiringAbsoluteAngles.get(firingAngleIndex));
                ++firingAngleIndex;
            }
            ++gunIndex;
        }
        this._activeWaves.add(newWave);
        int index = 0;
        while (index < this._generatedListener.size()) {
            WaveGeneratedListener listener = this._generatedListener.get(index);
            if (listener != null) {
                listener.OnWaveGenerated(newWave);
            }
            ++index;
        }
    }

    public WaveData GetWaveWhichCouldHaveHit(double x, double y, WaveData.eWaveType limitToWaveType) {
        double closestDistanceSq = Double.MAX_VALUE;
        WaveData closestWave = null;
        int activeWaves = this._activeWaves.size();
        long currentTick = AgentSmith.Instance().getTime();
        int index = 0;
        while (index < activeWaves) {
            double waveDistance;
            double waveDistanceSq;
            double dY;
            double dX;
            double distanceToWavesSourceSq;
            double distanceToWaveSq;
            WaveData wave = this._activeWaves.get(index);
            if ((limitToWaveType == WaveData.eWaveType.Any || wave.WaveType == limitToWaveType) && (distanceToWaveSq = Math.abs((distanceToWavesSourceSq = (dX = x - wave.VirtualGunData.FiringLocationX) * dX + (dY = y - wave.VirtualGunData.FiringLocationY) * dY) - (waveDistanceSq = (waveDistance = WaveDataUtils.GetWaveDistance(wave, currentTick)) * waveDistance))) < closestDistanceSq) {
                closestWave = wave;
                closestDistanceSq = distanceToWaveSq;
            }
            ++index;
        }
        return closestWave;
    }

    public void DebugDraw(Graphics2D gfx) {
        int activeWaves = this._activeWaves.size();
        long tick = AgentSmith.Instance().getTime();
        int index = 0;
        while (index < activeWaves) {
            WaveData wave = this._activeWaves.get(index);
            if (wave.WaveType != WaveData.eWaveType.Virtual) {
                WaveDataUtils.DebugDraw(gfx, wave, this._debugColour, tick);
            }
            ++index;
        }
    }

    public void AddTargetListener(WaveTargetListener targetListener) {
        this._targetListeners.add(targetListener);
    }

    public void AddGeneratedListener(WaveGeneratedListener listener) {
        this._generatedListener.add(listener);
    }

    public void AddRemovedListener(WaveRemovedListener listener) {
        this._removedListeners.add(listener);
    }

    public int GetNumActiveWaves() {
        return this._activeWaves.size();
    }

    public WaveData GetActiveWave(int index) {
        return this._activeWaves.get(index);
    }

    protected boolean CheckWaveShouldBeRemoved(WaveData wave) {
        return WaveDataUtils.GetWaveDistance(wave, AgentSmith.Instance().getTime()) > 1000.0;
    }
}

