/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.core;

import dsekercioglu.mega.core.DistancedGuessFactor;
import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.jk.KDTree;
import java.util.ArrayList;

public class KNNView {
    KDTree<GuessFactor> kdTree;
    final double[] WEIGHTS;
    final int K;
    final int DIVISOR;

    public KNNView(int k, int divisor, double[] weights) {
        this.K = k;
        this.DIVISOR = divisor;
        this.WEIGHTS = weights;
        this.kdTree = new KDTree.Manhattan<GuessFactor>(this.WEIGHTS.length);
    }

    public ArrayList<DistancedGuessFactor> nearestNeighbours(double[] searchPoint) {
        ArrayList<DistancedGuessFactor> guessFactors = new ArrayList<DistancedGuessFactor>();
        double[] weightedSearchPoint = this.weightDataPoints(searchPoint);
        ArrayList<KDTree.SearchResult<GuessFactor>> nearestNeighbours = this.kdTree.nearestNeighbours(weightedSearchPoint, Math.max(Math.min(this.K, this.kdTree.size() / this.DIVISOR), 1));
        for (int i = 0; i < nearestNeighbours.size(); ++i) {
            KDTree.SearchResult<GuessFactor> result = nearestNeighbours.get(i);
            GuessFactor guessFactor = (GuessFactor)result.payload;
            DistancedGuessFactor distancedGuessFactor = new DistancedGuessFactor(guessFactor, result.distance);
            guessFactors.add(distancedGuessFactor);
        }
        return guessFactors;
    }

    public void addDataPoint(double[] dataPoint, GuessFactor guessFactor) {
        this.kdTree.addPoint(this.weightDataPoints(dataPoint), guessFactor);
    }

    private double[] weightDataPoints(double[] dataPoint) {
        double[] weightedDataPoint = new double[this.WEIGHTS.length];
        for (int i = 0; i < this.WEIGHTS.length; ++i) {
            weightedDataPoint[i] = dataPoint[i] * this.WEIGHTS[i];
        }
        return weightedDataPoint;
    }
}

