/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.RobotHistory;

import java.util.ArrayList;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;

public class RobotHistory {
    public ArrayList<RobotSnapshot> Snapshots = null;
    public int SnapshotCount = 0;
    private int _maxSnapshotCount;

    public RobotHistory(int maxSnapshotCount) {
        this.Snapshots = new ArrayList(maxSnapshotCount);
        this._maxSnapshotCount = maxSnapshotCount;
        for (int index = 0; index < this._maxSnapshotCount; ++index) {
            this.Snapshots.add(new RobotSnapshot());
        }
    }

    public void Clear() {
        this.SnapshotCount = 0;
    }

    public RobotSnapshot GetSnapshotForWriting() {
        int snapshotIndexToRemove = Math.min(this.SnapshotCount, this._maxSnapshotCount - 1);
        if (snapshotIndexToRemove < this.SnapshotCount) {
            --this.SnapshotCount;
        }
        return this.Snapshots.remove(snapshotIndexToRemove);
    }

    public void SubmitSnapshot(RobotSnapshot snapshot) {
        this.Snapshots.add(0, snapshot);
        if (this.SnapshotCount < this._maxSnapshotCount) {
            ++this.SnapshotCount;
        }
    }

    public RobotSnapshot GetSnapshotForTick(long tick) {
        for (int index = 0; index < this.SnapshotCount; ++index) {
            RobotSnapshot snapshot = this.Snapshots.get(index);
            if (snapshot.Tick == tick) {
                return snapshot;
            }
            if (snapshot.Tick >= tick) continue;
            return null;
        }
        return null;
    }
}

