/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.TacticalLead;
import alk.lap.strategy.VirtualBattleField;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.LapUtils;
import java.awt.Color;

public class OccurenceTargeting
implements TargetStrategy {
    private static final double BEAM_ANGLE = 4.0;
    public static final String NAME = "OccT";
    private static final double PULL_CURRENT_TO_MAX_DEFAULT = 0.5;
    private double fireEnergy = 3.0;
    private double pullCurrentToMax = 0.5;
    private String name = "OccT";
    LoudAndProud proud;

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return this.pullCurrentToMax > 0.2 ? TargetStrategy.StrategyType.MoveBased : TargetStrategy.StrategyType.Heuristic;
    }

    public Color getColorCode() {
        return Color.orange;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        DVektor targetsMostFrequentedCell = null;
        DVektor targetsCurrentPosition = null;
        DVektor gunnersPosition = null;
        TacticalLead tLead = this.proud.getTacticLead();
        if (target == 0) {
            if (!tLead.isEnemySpotted()) {
                return LapUtils.toDArray(this.proud.getRadarHeading());
            }
            VirtualBattleField.Cell theCell = tLead.getVBattleField().getMostFrequentedCell();
            theCell.mark("x");
            targetsMostFrequentedCell = theCell.getCenter();
            targetsCurrentPosition = tLead.getEnemyPos();
            gunnersPosition = this.proud.getPosition();
        } else {
            targetsMostFrequentedCell = tLead.getVBattleField().getProudsMostFrequentedCell().getCenter();
            targetsCurrentPosition = wave.proudsPositionAtEmission;
            gunnersPosition = wave.emittingPosition;
        }
        DVektor deltaBetweenPosAndCell = DVektor.sub(targetsCurrentPosition, targetsMostFrequentedCell);
        deltaBetweenPosAndCell.x *= this.pullCurrentToMax;
        deltaBetweenPosAndCell.y *= this.pullCurrentToMax;
        DVektor targetPoint = DVektor.add(targetsCurrentPosition, deltaBetweenPosAndCell);
        if (target == 0) {
            this.proud.getVc().drawPoint(targetPoint, "adjusted target:" + this.describe());
            this.proud.getVc().drawPoint(targetsMostFrequentedCell, "mfcCenter");
        }
        return LapUtils.toDArray(gunnersPosition.getDirectionTo(targetPoint));
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return 4.0;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }

    public OccurenceTargeting setPullCurrentToMax(double pullToCurrent) {
        this.pullCurrentToMax = pullToCurrent;
        this.setName(String.valueOf(this.describe()) + "-" + LoudAndProud.printStaticDouble(pullToCurrent * 100.0));
        return this;
    }

    public OccurenceTargeting setName(String name) {
        this.name = name;
        return this;
    }

    public OccurenceTargeting setFireEnergy(double e) {
        this.setName(String.valueOf(this.describe()) + "-f" + LoudAndProud.printStaticDouble(e));
        return this;
    }
}

