/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.moves.MeleeMove;

import gre.svman4.enemies.Enemy;
import gre.svman4.useful.Force;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.util.HashMap;

public class EnemyForce
extends Force {
    public double[] calculate(HashMap<String, Enemy> enemies, RobotState mineRobot, int saveInfo) {
        double xForce = 0.0;
        double yForce = 0.0;
        int aliveEnemiesCount = 0;
        for (Enemy enemy : enemies.values()) {
            if (!enemy.alive) continue;
            ++aliveEnemiesCount;
            double enemyEnergy = enemy.energy;
            double angleToEnemy = mineRobot.getAngleTo(enemy);
            double distanceSq = mineRobot.distanceSq(enemy);
            xForce -= enemyEnergy * Math.sin(angleToEnemy) / (distanceSq + 1.0);
            yForce -= enemyEnergy * Math.cos(angleToEnemy) / (distanceSq + 1.0);
        }
        if (aliveEnemiesCount == 0) {
            xForce = 0.0;
            yForce = 0.0;
        } else {
            xForce /= (double)aliveEnemiesCount;
            yForce /= (double)aliveEnemiesCount;
        }
        if (saveInfo == 1) {
            this.setX(xForce);
            this.setY(yForce);
        }
        return new double[]{xForce, yForce};
    }

    @Override
    public Color getColor() {
        return Color.PINK;
    }

    @Override
    protected String getName() {
        return "EnemyForce";
    }
}

