/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.radars;

import gre.svman4.radars.Radar;
import gre.svman4.useful.RobotState;
import gre.svman4.useful.TargetControlled;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class OneVsOneRadar
extends Radar
implements TargetControlled {
    protected RobotState _target;

    public OneVsOneRadar(AdvancedRobot robot) {
        super(robot);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        double angleToEnemy = this._robot.getHeadingRadians() + event.getBearingRadians();
        double moduleTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this._robot.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(45.0 / event.getDistance()), Rules.RADAR_TURN_RATE_RADIANS);
        this._robot.setTurnRadarRightRadians(moduleTurn += moduleTurn < 0.0 ? -extraTurn : extraTurn);
    }

    @Override
    public String getName() {
        return "OneVsOne radar";
    }

    @Override
    public void setTarget(RobotState enemy) {
        this._target = enemy;
    }
}

