/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Position;
import fnc.bandit.Util;
import java.io.PrintStream;

public class Path {
    final int maxpositions = 40;
    Position[] history;
    int top;
    int count;
    double width;
    double height;
    PrintStream output;

    public Path(Position position, double d, double d2, PrintStream printStream) {
        this.width = d;
        this.height = d2;
        this.output = printStream;
        this.top = 0;
        this.count = 1;
        this.history = new Position[40];
        this.history[this.top] = new Position(position);
    }

    public Position getPosition(int n) {
        int n2 = this.top + n;
        if (n2 < 0) {
            n2 += 40;
        }
        return new Position(this.history[n2]);
    }

    public int getCount() {
        return this.count;
    }

    public void add(Position position) {
        if (position.t != this.history[this.top].t) {
            int n = this.top + 1;
            if (n >= 40) {
                n = 0;
            }
            this.history[n] = new Position(position);
            if (this.itMoved(this.history[this.top].x, position.x) || this.itMoved(this.history[this.top].y, position.y)) {
                if (Math.abs(this.history[this.top].bearing(position) - position.h) > 1.2566370614359172) {
                    this.history[n].h = Util.normalize2(position.h + Math.PI);
                }
            } else {
                this.history[n].h = this.history[this.top].h;
            }
            this.top = n;
            if (this.count < 40) {
                ++this.count;
            }
        }
    }

    public final boolean itMoved(double d, double d2) {
        return Math.abs(d - d2) > 0.01;
    }

    public void dump(PrintStream printStream) {
        int n;
        int n2;
        if (this.count < 40) {
            n2 = 0;
            n = this.count;
        } else {
            n2 = (this.top + 1) % 40;
            n = 40;
        }
        printStream.println(this.history[n2]);
        n2 = (n2 + 1) % 40;
        --n;
        while (n > 0) {
            printStream.println(this.history[n2]);
            n2 = (n2 + 1) % 40;
            --n;
        }
    }
}

