/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.predict.Buckets;
import dk.predict.Factors;
import dk.predict.Predictor;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class EnemyPositionPredictor {
    protected List predictionBuckets;
    public static boolean printBuckets = true;

    public EnemyPositionPredictor(List buckets) {
        this.predictionBuckets = buckets;
    }

    public void printBuckets(PrintStream out) {
        if (this.predictionBuckets != null) {
            Iterator iter = this.predictionBuckets.iterator();
            while (iter.hasNext()) {
                Buckets buckets = (Buckets)iter.next();
                out.println("**************");
                buckets.printStats(out);
            }
        }
    }

    public List getPredictionBuckets() {
        return this.predictionBuckets;
    }

    public Predictor getBestPredictor(Base r, Enemy e, double power) {
        Histogram.Bucket bucket = this.getBestPredictorBucket(r, e, power);
        return (Predictor)bucket.getObject();
    }

    public Histogram.Bucket getBestPredictorBucket(Base r, Enemy e, double power) {
        return this.getBestPredictorBucket(new Factors(r, e, power));
    }

    public Histogram.Bucket getBestPredictorBucket(Factors f) {
        Histogram.Bucket bestBucket = null;
        Iterator iter = this.predictionBuckets.iterator();
        while (iter.hasNext()) {
            Buckets buckets = (Buckets)iter.next();
            Histogram.Bucket hb = buckets.getBucket(f);
            if (bestBucket == null) {
                bestBucket = hb;
                continue;
            }
            if (!(hb.getSuccessRate() - hb.getConfidence() > bestBucket.getSuccessRate() - bestBucket.getConfidence())) continue;
            bestBucket = hb;
        }
        if (bestBucket == null) {
            return null;
        }
        return bestBucket;
    }
}

