/*
 * Decompiled with CFR 0.152.
 */
package jbot.engines;

import java.awt.Graphics2D;
import java.util.Random;
import jbot.Rabbit2;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import robocode.HitByBulletEvent;

public abstract class Engine {
    public static final double BASE_BEST_DISTANCE = 300.0;
    protected Rabbit2 mBot;
    protected Tracer mTracer;
    protected Target mTarget;
    protected Target mSelf;
    protected double mAheadDir;
    protected double mAhead;
    protected double mTurnBearing;
    Random mRandom;

    protected Engine(Rabbit2 bot) {
        this.mBot = bot;
        this.mRandom = this.mBot.getRandom();
        this.mTracer = this.mBot.getTracer();
        this.mTarget = this.mTracer.getEnemyTarget();
        this.mSelf = this.mTracer.getSelfTarget();
        this.mAheadDir = this.mRandom.nextDouble() - 0.5 > 0.0 ? 1.0 : -1.0;
        this.mAhead = 0.0;
        this.mTurnBearing = 0.0;
    }

    public void frame(double deltaTime) {
        this.frameLogic(deltaTime);
        this.mBot.setTurnRightRadians(this.mTurnBearing);
        this.mBot.setAhead(this.mAhead);
    }

    protected abstract void frameLogic(double var1);

    public void onHitByBullet(HitByBulletEvent evt) {
    }

    public void onPaint(Graphics2D g) {
    }
}

