/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import jbot.Rabbit2;
import jbot.tracer.Target;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.Vector2;
import robocode.Rules;

public class WallsGravityTechnique
extends TracerTechnique {
    public static final int BOTTOM = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int LEFT = 3;
    public static final int WALLS_INTERACTION_DIST = 100;
    public static final double ACCELERATION_GAIN_FACTOR = 0.1;
    public static final double SPEED_GAIN_FACTOR = 0.2;
    double mAvgSpeed = 4.0;
    Vector2 mWallAcceleration = new Vector2();
    Vector2 mCornerAcceleration = new Vector2();
    Vector2[] mWallsDirs = new Vector2[4];
    boolean[] mIsNearWalls = new boolean[4];
    double[] mLastWallsDistances = new double[4];
    double[] mRecentWallsDistances = new double[4];
    double mLastAvgDistance = 300.0;
    double mRecentAvgDistance = 300.0;
    int mNearWallsNum = 0;
    double mWallsInteractionFactor;

    public WallsGravityTechnique(String techName, Rabbit2 bot, Target self, Target target, double initInaccuracy, double learnFactor) {
        super(techName, bot, self, target, initInaccuracy, learnFactor);
        this.mColor = Color.GREEN;
        this.mWallsDirs[0] = Vector2.UP.clone();
        this.mWallsDirs[1] = Vector2.LEFT.clone();
        this.mWallsDirs[2] = Vector2.BOTTOM.clone();
        this.mWallsDirs[3] = Vector2.RIGHT.clone();
        int i = 0;
        while (i < 4) {
            this.mIsNearWalls[i] = false;
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.mLastWallsDistances[i] = 300.0;
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.mRecentWallsDistances[i] = 300.0;
            ++i;
        }
    }

    protected void frameLogic(double deltaTime) {
        double learnFactor = 0.2 * this.getEfficient();
        this.mAvgSpeed = this.mAvgSpeed * (1.0 - learnFactor) + this.mTarget.getSpeed() * learnFactor;
        Vector2 targetPos = this.mTarget.getPosition();
        this.mLastWallsDistances = (double[])this.mRecentWallsDistances.clone();
        this.mLastAvgDistance = this.mRecentAvgDistance;
        int w = (int)this.mBot.getBattleFieldWidth();
        int h = (int)this.mBot.getBattleFieldHeight();
        int x = (int)targetPos.getX();
        int y = (int)targetPos.getY();
        int d = 100;
        int i = 0;
        while (i < 4) {
            this.mIsNearWalls[i] = false;
            ++i;
        }
        this.mNearWallsNum = 0;
        double distanceSum = 0.0;
        if (y < d) {
            this.mRecentWallsDistances[0] = y;
            this.mIsNearWalls[0] = true;
            distanceSum += this.mRecentWallsDistances[0];
            ++this.mNearWallsNum;
        } else if (x > w - d) {
            this.mRecentWallsDistances[1] = w - x;
            this.mIsNearWalls[1] = true;
            distanceSum += this.mRecentWallsDistances[1];
            ++this.mNearWallsNum;
        } else if (y > h - d) {
            this.mRecentWallsDistances[2] = h - y;
            this.mIsNearWalls[2] = true;
            distanceSum += this.mRecentWallsDistances[2];
            ++this.mNearWallsNum;
        } else if (x < d) {
            this.mRecentWallsDistances[3] = x;
            this.mIsNearWalls[3] = true;
            distanceSum += this.mRecentWallsDistances[3];
            ++this.mNearWallsNum;
        }
        this.mRecentAvgDistance = this.mNearWallsNum > 0 ? distanceSum / (double)this.mNearWallsNum : 100.0;
        this.calcWallsInteractionFactor();
        this.selfLearnNearWall();
    }

    public double getWallsInteractionFactor() {
        return this.mWallsInteractionFactor;
    }

    protected void calcWallsInteractionFactor() {
        double gain = (this.mRecentAvgDistance - this.mLastAvgDistance) / 8.0;
        if (gain > 0.0) {
            gain /= 4.0;
        }
        gain = Math.abs(gain);
        this.mWallsInteractionFactor = 1.0 - (this.mRecentAvgDistance - 20.0) / 80.0;
        this.mWallsInteractionFactor = Math.sqrt(this.mWallsInteractionFactor);
        this.mWallsInteractionFactor *= gain;
        this.mWallsInteractionFactor = Math.sqrt(this.mWallsInteractionFactor);
    }

    protected void selfLearnNearWall() {
        double gain = Math.abs(this.mRecentAvgDistance - this.mLastAvgDistance) / 8.0 * this.getEfficient();
        Vector2 currVel = this.mTarget.getVelocity();
        Vector2 lastVel = this.mTarget.getHistoryAgo(1).getVelocity();
        Vector2 velAcc = currVel.clone().sub(lastVel);
        velAcc.multiply(0.1 * gain);
        this.mWallAcceleration.multiply(1.0 - 0.1 * gain);
        int i = 0;
        while (i < 4) {
            if (this.mIsNearWalls[i]) {
                Vector2 a = velAcc.clone().rotate(-this.mWallsDirs[i].getAngle());
                a.multiply(1.0 / (double)this.mNearWallsNum);
                this.mWallAcceleration.add(a);
            }
            ++i;
        }
    }

    public double getShotAngleFor(long shootTime, Vector2 shootPos, double shootPower) {
        Target.Data target = this.mTarget.getHistoryAt(shootTime);
        Vector2 distance = target.getPosition().sub(shootPos);
        double shootSpeed = Rules.getBulletSpeed((double)shootPower);
        double maxSpeed = (Math.abs(this.mAvgSpeed) * 2.0 + 8.0) / 3.0;
        this.mEstimatedPath.clear();
        Vector2 v = target.getVelocity();
        Vector2 a = new Vector2();
        int t = 0;
        int i = 0;
        while (i < 4) {
            if (this.mIsNearWalls[i]) {
                Vector2 ta = this.mWallAcceleration.clone();
                ta.rotate(this.mWallsDirs[i].getAngle());
                a.add(ta);
            }
            ++i;
        }
        do {
            ++t;
            v.add(a);
            if (v.getLength() > maxSpeed) {
                v.multiply(maxSpeed / v.getLength());
            }
            distance.add(v);
            this.mEstimatedPath.add(distance.clone().add(shootPos));
        } while (!(distance.getLength() / shootSpeed > (double)t - 1.0 && distance.getLength() / shootSpeed < (double)t + 1.0) && t <= 40);
        distance.add(shootPos);
        if (distance.getX() < 20.0) {
            distance.setX(20.0);
        } else if (distance.getX() > this.mBot.getBattleFieldWidth() - 20.0) {
            distance.setX(this.mBot.getBattleFieldWidth() - 20.0);
        }
        if (distance.getY() < 20.0) {
            distance.setY(20.0);
        } else if (distance.getY() > this.mBot.getBattleFieldHeight() - 20.0) {
            distance.setY(this.mBot.getBattleFieldHeight() - 20.0);
        }
        distance.sub(shootPos);
        return distance.getAngle();
    }
}

