/*
 * Decompiled with CFR 0.152.
 */
package kid.data;

import java.util.Collection;
import kid.data.Closest;
import kid.data.Easiest;
import kid.robot.EnemyData;
import kid.robot.RobotData;
import kid.robot.TeammateData;
import robocode.Robot;

public abstract class RobotChooser {
    protected RobotData lastRobot = new RobotData();
    protected long lastTime_Robot = -1L;
    protected EnemyData lastEnemy = new EnemyData();
    protected long lastTime_Enemy = -1L;
    protected TeammateData lastTeammate = new TeammateData();
    protected long lastTime_Teammate = -1L;
    public static final RobotChooser CLOSEST = new Closest();
    public static final RobotChooser EASIEST = new Easiest();

    public RobotData getRobot(Robot myRobot, Collection<RobotData> robots) {
        if (this.lastRobot.isDead()) {
            this.lastTime_Robot = -1L;
            this.lastRobot = new RobotData();
        } else if (myRobot.getTime() == this.lastTime_Robot) {
            return this.lastRobot;
        }
        this.lastRobot = this.getRobotOverride(myRobot, robots);
        this.lastTime_Robot = myRobot.getTime();
        return this.lastRobot;
    }

    public EnemyData getEnemy(Robot myRobot, Collection<EnemyData> enemys) {
        if (this.lastEnemy.isDead()) {
            this.lastTime_Enemy = -1L;
            this.lastEnemy = new EnemyData();
        } else if (myRobot.getTime() == this.lastTime_Enemy) {
            return this.lastEnemy;
        }
        this.lastEnemy = this.getEnemyOverride(myRobot, enemys);
        this.lastTime_Enemy = myRobot.getTime();
        return this.lastEnemy;
    }

    public TeammateData getTeammate(Robot myRobot, Collection<TeammateData> teammates) {
        if (this.lastTeammate.isDead()) {
            this.lastTime_Teammate = -1L;
            this.lastTeammate = new TeammateData();
        } else if (myRobot.getTime() == this.lastTime_Teammate) {
            return this.lastTeammate;
        }
        this.lastTeammate = this.getTeammateOverride(myRobot, teammates);
        this.lastTime_Teammate = myRobot.getTime();
        return this.lastTeammate;
    }

    protected abstract RobotData getRobotOverride(Robot var1, Collection<RobotData> var2);

    protected abstract EnemyData getEnemyOverride(Robot var1, Collection<EnemyData> var2);

    protected abstract TeammateData getTeammateOverride(Robot var1, Collection<TeammateData> var2);
}

