/*
 * Decompiled with CFR 0.152.
 */
package kid.virtual;

import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.robot.RobotData;
import kid.targeting.HeadOnTargeting;
import kid.targeting.Targeting;
import kid.utils.Utils;
import kid.virtual.VirtualBullet;
import kid.virtual.VirtualObject;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;

public class VirtualGun
extends VirtualObject {
    private static final long serialVersionUID = 1715236387787837088L;
    private Targeting targeting;
    private RobotData target;
    private transient List<VirtualBullet> virtualBullets;
    private transient List<Bullet> realBullets;
    private double virtualFired;
    private double virtualHit;
    private double realFired;
    private double realHit;

    public VirtualGun(AdvancedRobot myRobot) {
        this.init(myRobot, new RobotData(), new HeadOnTargeting((Robot)myRobot));
    }

    public VirtualGun(AdvancedRobot myRobot, RobotData target, Targeting targeting) {
        this.init(myRobot, target, targeting);
    }

    private VirtualGun(VirtualGun gun) {
        this.init(null, gun.getTarget(), gun.getTargeting());
    }

    private void init(AdvancedRobot myRobot, RobotData target, Targeting targeting) {
        if (myRobot != null) {
            myRobot.addCustomEvent((Condition)new BulletWatcher(myRobot.getTime()));
        }
        this.target = target;
        this.targeting = targeting;
        this.virtualBullets = new ArrayList<VirtualBullet>();
        this.realBullets = new ArrayList<Bullet>();
        this.virtualFired = 0.0;
        this.virtualHit = 0.0;
        this.realFired = 0.0;
        this.realHit = 0.0;
    }

    public void update(AdvancedRobot myRobot) {
        if (myRobot != null) {
            myRobot.addCustomEvent((Condition)new BulletWatcher(myRobot.getTime()));
        }
        this.virtualBullets = new ArrayList<VirtualBullet>();
        this.realBullets = new ArrayList<Bullet>();
    }

    public void fire(double firePower) {
        this.virtualBullets.add(this.targeting.getBullet(this.target, firePower));
    }

    public void fire(Bullet bullet) {
        if (bullet != null) {
            this.realBullets.add(bullet);
        }
    }

    public Targeting getTargeting() {
        return this.targeting;
    }

    protected RobotData getTarget() {
        return this.target;
    }

    protected List<VirtualBullet> getVirtualBullets() {
        return this.virtualBullets;
    }

    protected List<Bullet> getRealBullets() {
        return this.realBullets;
    }

    public double getVirtualHitRate() {
        return this.virtualHit / this.virtualFired;
    }

    public double getRealHitRate() {
        return this.realHit / this.realFired;
    }

    public double getCombinedHitRate() {
        return Utils.weightedAvg(this.getVirtualHitRate(), this.virtualFired, this.getRealHitRate(), 2.0 * this.realFired);
    }

    public double getHitRate() {
        if (this.getRealHitRate() >= 0.0) {
            return this.getCombinedHitRate();
        }
        if (this.getVirtualHitRate() >= 0.0) {
            return this.getVirtualHitRate();
        }
        return -1.0;
    }

    @Override
    public void print(PrintStream console) {
        console.println("Virtual Gun for: " + this.target.getName() + " (" + this.targeting.getName() + ")");
        console.println("   Virtual:  (" + this.virtualHit + "/" + this.virtualFired + ") " + this.getVirtualHitRate());
        console.println("   Real:     (" + this.realHit + "/" + this.realFired + ") " + this.getRealHitRate());
        console.println("   Compined: " + this.getCombinedHitRate());
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    public Object clone() {
        return new VirtualGun(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualGun) {
            VirtualGun gun = (VirtualGun)obj;
            return gun.getTarget().equals(this.target) && gun.getTargeting().equals(this.targeting);
        }
        return false;
    }

    public String toString() {
        return new String("Virtual Gun for: " + this.target.getName() + " (" + this.targeting.getName() + ") Virtual: " + this.getVirtualHitRate() + " Real: " + this.getRealHitRate() + " Compined: " + this.getCombinedHitRate());
    }

    public void finalize() {
        this.targeting = null;
        this.target = null;
        this.virtualBullets = null;
        this.virtualFired = 0.0;
        this.virtualHit = 0.0;
        this.realBullets = null;
        this.realFired = 0.0;
        this.realHit = 0.0;
    }

    @Override
    public void draw(RGraphics grid) {
        grid.setColor(this.targeting.getColor());
        if (DrawMenu.getValue("Virtual Bullets", "Targeting")) {
            for (VirtualBullet vb : this.virtualBullets) {
                vb.draw(grid);
            }
        }
        if (DrawMenu.getValue("Real Bullets", "Targeting")) {
            for (Bullet b : this.realBullets) {
                grid.drawOvalCenter(b.getX(), b.getY(), 10.0, 10.0);
            }
        }
    }

    public void drawGunStats(RGraphics grid) {
        if (DrawMenu.getValue("Gun Statistics", "Targeting")) {
            grid.setColor(this.targeting.getColor());
            double x = grid.getRobot().getX();
            double y = grid.getRobot().getY();
            double dist = 30.0 + Math.max(0.0, 70.0 * this.getHitRate());
            if (!this.target.isDead()) {
                double angle = this.targeting.getAngle(this.target, 2.0);
                grid.drawLine(x, y, Utils.getX(x, dist, angle), Utils.getY(y, dist, angle));
            }
            grid.drawOvalCenter(x, y, 2.0 * dist, 2.0 * dist);
        }
    }

    public void drawOptions(RGraphics grid) {
    }

    public void inMouseEvent(MouseEvent e) {
    }

    private class BulletWatcher
    extends Condition {
        private long time;

        public BulletWatcher(long curTime) {
            this.init(curTime);
        }

        private void init(long curTime) {
            this.time = curTime;
        }

        public boolean test() {
            VirtualBullet b;
            int i = 0;
            while (i < VirtualGun.this.virtualBullets.size()) {
                b = (VirtualBullet)VirtualGun.this.virtualBullets.get(i);
                if (b.testHit(VirtualGun.this.target.getRectangle(), this.time)) {
                    VirtualGun virtualGun = VirtualGun.this;
                    virtualGun.virtualHit = virtualGun.virtualHit + 1.0;
                    VirtualGun virtualGun2 = VirtualGun.this;
                    virtualGun2.virtualFired = virtualGun2.virtualFired + 1.0;
                    VirtualGun.this.virtualBullets.remove(i--);
                } else if (!b.testActive(this.time) || b.testMissed(VirtualGun.this.target.getRectangle(), this.time - 5L)) {
                    VirtualGun virtualGun = VirtualGun.this;
                    virtualGun.virtualFired = virtualGun.virtualFired + 1.0;
                    VirtualGun.this.virtualBullets.remove(i--);
                }
                ++i;
            }
            i = 0;
            while (i < VirtualGun.this.realBullets.size()) {
                b = (Bullet)VirtualGun.this.realBullets.get(i);
                if (!b.isActive()) {
                    if (b.getVictim() != null && b.getVictim().equals(VirtualGun.this.target.getName())) {
                        VirtualGun virtualGun = VirtualGun.this;
                        virtualGun.realHit = virtualGun.realHit + 1.0;
                    }
                    VirtualGun virtualGun = VirtualGun.this;
                    virtualGun.realFired = virtualGun.realFired + 1.0;
                    VirtualGun.this.realBullets.remove(i--);
                }
                ++i;
            }
            ++this.time;
            return false;
        }
    }
}

