/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.EnemyWaveListener;
import mue.Knowledge;
import mue.Util;
import robocode.AdvancedRobot;
import robocode.Condition;

class EnemyWave
extends Condition {
    private AdvancedRobot target;
    private EnemyWaveListener listener;
    private double originX;
    private double originY;
    private double targetX;
    private double targetY;
    private double targetHeading;
    private int targetVelocity;
    private int targetAcceleration;
    private double power;
    private long time;
    private double speed;
    boolean real;

    public EnemyWave(EnemyWaveListener enemyWaveListener, AdvancedRobot advancedRobot, Knowledge knowledge, double d, double d2) {
        super("EnemyWave");
        this.listener = enemyWaveListener;
        this.target = advancedRobot;
        this.time = this.target.getTime() - 1L;
        this.originX = d;
        this.originY = d2;
        this.targetX = knowledge.getOldX();
        this.targetY = knowledge.getOldY();
        this.targetHeading = knowledge.getOldHeading();
        this.targetVelocity = knowledge.getOldVelocity();
        this.targetAcceleration = knowledge.getOldAcceleration();
    }

    public void fire(double d, boolean bl) {
        this.power = d;
        this.real = bl;
        this.speed = 20.0 - 3.0 * this.power;
        this.target.addCustomEvent((Condition)this);
    }

    public boolean test() {
        double d = Util.distance(this.originX, this.originY, this.target.getX(), this.target.getY());
        if ((double)(this.target.getTime() - this.time) * this.speed < d) {
            return false;
        }
        this.listener.onEnemyWave(this.time, this.originX, this.originY, this.targetX, this.targetY, this.targetHeading, this.targetVelocity, this.targetAcceleration, this.power, this.real);
        this.target.removeCustomEvent((Condition)this);
        return false;
    }
}

