/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Heading;
import shrub.MHTracker;
import shrub.Phasor;
import shrub.RobotDataStore;
import shrub.Sighting;
import shrub.TurretInstruction;
import shrub.TurretModeAPI;
import shrub.TurretModeCRR;
import shrub.TurretModeNOP;
import shrub.TurretModePAH;
import shrub.TurretModeRTH;

public class TurretMgrWaggle
implements TurretModeAPI {
    private final TurretModeAPI mTurretModeNOP;
    private final TurretModeAPI mTurretModeCRR;
    private final TurretModeAPI mTurretModeRTH;
    private final TurretModeAPI mTurretModePAH;
    private final MHTracker mTrackerRef;
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();

    public TurretMgrWaggle(MHTracker trackerRef) {
        this.mTrackerRef = trackerRef;
        this.mTurretModeNOP = new TurretModeNOP();
        this.mTurretModeCRR = new TurretModeCRR(20.0);
        this.mTurretModeRTH = new TurretModeRTH(20.0);
        double[] phasor3x5Array = new double[]{0.0, -5.0, -10.0, -15.0, -10.0, -5.0, 0.0, 5.0, 10.0, 15.0, 10.0, 5.0};
        Phasor phasor3x5 = new Phasor(phasor3x5Array);
        this.mTurretModePAH = new TurretModePAH(20.0, phasor3x5);
    }

    public TurretInstruction generateInstruction() {
        TurretInstruction instruct = null;
        if (this.mDataStore.getNumOthers() == 0L) {
            instruct = this.mTurretModeCRR.generateInstruction();
        } else if (!this.mTrackerRef.HasLockOn()) {
            instruct = this.mTurretModeNOP.generateInstruction();
        } else {
            Sighting currentTarget = this.mTrackerRef.GetCurrentTarget();
            Heading hdngToTarget = Heading.valueOfFromTo(this.mDataStore.getMyLocn(), currentTarget.GetLocation());
            double perpVel = hdngToTarget.CrossComponent(currentTarget.GetHeading(), currentTarget.GetVelocity());
            int leadAngle = TurretMgrWaggle.calcLeadAngle(perpVel);
            Heading leadTarget = Heading.valueOfAdjust(hdngToTarget, leadAngle);
            if (leadAngle == 0) {
                ((TurretModeRTH)this.mTurretModeRTH).setTargetHdng(leadTarget);
                instruct = this.mTurretModeRTH.generateInstruction();
            } else {
                ((TurretModePAH)this.mTurretModePAH).setTargetHdng(leadTarget);
                instruct = this.mTurretModePAH.generateInstruction();
            }
        }
        return instruct;
    }

    private static int calcLeadAngle(double perpVel) {
        int leadAdjustVal = 0;
        leadAdjustVal = perpVel <= -6.0 ? -20 : (perpVel <= -4.5 ? -15 : (perpVel <= -3.0 ? -10 : (perpVel <= -1.5 ? -5 : (perpVel < 1.5 ? 0 : (perpVel < 3.0 ? 5 : (perpVel < 4.5 ? 10 : (perpVel < 6.0 ? 15 : 20)))))));
        return leadAdjustVal;
    }
}

