/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.data;

import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.WinEvent;
import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.data.ScoreGL;

public class Score {
    FractalE robot;
    Memory memory;
    ScoreGL scoregl;
    public double[] bullet = new double[2];
    public double[] curbullet = new double[2];
    public double[] survival = new double[2];

    public Score(FractalE robot, Memory memory) {
        this.robot = robot;
        this.memory = memory;
        if (FractalE.glhud) {
            this.scoregl = new ScoreGL(FractalE.renderer, memory, this);
        }
    }

    public void update(int id) {
        if (FractalE.glhud) {
            this.scoregl.update(id);
        }
    }

    public void init() {
        if (FractalE.glhud) {
            this.scoregl.init();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (e.getEnergy() > 0.001) {
            this.curbullet[0] = this.curbullet[0] + (4.0 * e.getBullet().getPower() + 2.0 * Math.max(e.getBullet().getPower() - 1.0, 0.0));
            this.update(0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.curbullet[1] = this.curbullet[1] + (4.0 * e.getBullet().getPower() + 2.0 * Math.max(e.getBullet().getPower() - 1.0, 0.0));
        this.update(1);
    }

    public void onWin(WinEvent e) {
        this.survival[0] = this.survival[0] + 60.0;
        Packet junk = this.memory.getPacketOffset(1, -1);
        if (junk != null) {
            this.curbullet[0] = this.curbullet[0] + junk.energy;
        }
        this.bullet[0] = this.bullet[0] + this.curbullet[0] * 1.2;
        this.bullet[1] = this.bullet[1] + this.curbullet[1];
        this.curbullet[0] = 0.0;
        this.curbullet[1] = 0.0;
        this.update(0);
        this.update(1);
    }

    public void onDeath(DeathEvent e) {
        this.survival[1] = this.survival[1] + 60.0;
        Packet junk = this.memory.getPacketOffset(0, -1);
        if (junk != null) {
            this.curbullet[1] = this.curbullet[1] + junk.energy;
        }
        this.bullet[0] = this.bullet[0] + this.curbullet[0];
        this.bullet[1] = this.bullet[1] + this.curbullet[1] * 1.2;
        this.curbullet[0] = 0.0;
        this.curbullet[1] = 0.0;
        this.update(0);
        this.update(1);
    }

    public void printScore() {
        int i;
        System.out.println("  ***********SCORECARD***********");
        System.out.print("  ");
        for (int i2 = 0; i2 < Math.max(this.robot.getName().length(), this.memory.name[1].length()); ++i2) {
            System.out.print(" ");
        }
        System.out.println(" Total Survival Bullet");
        String p0 = "  " + this.robot.getName();
        String p1 = "  " + this.memory.name[1];
        String pTemp = " " + Math.round(this.bullet[0] + this.survival[0]);
        for (i = this.robot.getName().length(); i < Math.max(this.robot.getName().length(), this.memory.name[1].length()) + 7 - pTemp.length(); ++i) {
            p0 = p0 + " ";
        }
        pTemp = " " + Math.round(this.bullet[1] + this.survival[1]);
        for (i = this.memory.name[1].length(); i < Math.max(this.robot.getName().length(), this.memory.name[1].length()) + 7 - pTemp.length(); ++i) {
            p1 = p1 + " ";
        }
        p0 = p0 + Math.round(this.bullet[0] + this.survival[0]) + "  ";
        p1 = p1 + Math.round(this.bullet[1] + this.survival[1]) + "  ";
        pTemp = " " + Math.round(this.survival[0]);
        for (i = 0; i < 8 - pTemp.length(); ++i) {
            p0 = p0 + " ";
        }
        pTemp = " " + Math.round(this.survival[1]);
        for (i = 0; i < 8 - pTemp.length(); ++i) {
            p1 = p1 + " ";
        }
        p0 = p0 + Math.round(this.survival[0]) + "  ";
        p1 = p1 + Math.round(this.survival[1]) + "  ";
        pTemp = " " + Math.round(this.bullet[0]);
        for (i = 0; i < 6 - pTemp.length(); ++i) {
            p0 = p0 + " ";
        }
        pTemp = " " + Math.round(this.bullet[1]);
        for (i = 0; i < 6 - pTemp.length(); ++i) {
            p1 = p1 + " ";
        }
        p0 = p0 + Math.round(this.bullet[0]);
        p1 = p1 + Math.round(this.bullet[1]);
        if (this.bullet[0] + this.survival[0] >= this.bullet[1] + this.survival[1]) {
            System.out.println(p0);
            System.out.println(p1);
        } else {
            System.out.println(p1);
            System.out.println(p0);
        }
    }
}

