/*
 * Decompiled with CFR 0.152.
 */
package xander.core.math;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import xander.core.math.RCMath;

public class VelocityVector
implements Cloneable {
    private double x;
    private double y;
    private Double roboAngle = null;

    public VelocityVector(double x, double y, double zeroDirection) {
        this.x = x;
        this.y = y;
        if (x == 0.0 && y == 0.0) {
            this.roboAngle = new Double(zeroDirection);
        }
    }

    public VelocityVector(double heading, double magnitude) {
        if (magnitude < 0.0) {
            heading = heading >= 180.0 ? (heading -= 180.0) : (heading += 180.0);
            magnitude = -magnitude;
        }
        this.roboAngle = new Double(heading);
        double nonDumbAngleInRadians = (90.0 - heading) * (Math.PI / 180);
        this.x = magnitude * Math.cos(nonDumbAngleInRadians);
        this.y = magnitude * Math.sin(nonDumbAngleInRadians);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void reverse() {
        this.x = -this.x;
        this.y = -this.y;
        if (this.roboAngle != null) {
            this.roboAngle = new Double(RCMath.normalizeDegrees(this.roboAngle + 180.0));
        }
    }

    public void add(VelocityVector vv) {
        this.x += vv.getX();
        this.y += vv.getY();
        if (this.x != 0.0 || this.y != 0.0) {
            this.roboAngle = null;
        }
    }

    public void add(double heading, double velocity) {
        Point2D.Double p = RCMath.getLocation(0.0, 0.0, velocity, heading);
        this.x += p.x;
        this.y += p.y;
        if (this.x != 0.0 || this.y != 0.0) {
            this.roboAngle = null;
        }
    }

    public void turn(double degrees) {
        double newAngle = this.getRoboAngle() + degrees;
        double mag = this.getMagnitude();
        double nonDumbAngleInRadians = (90.0 - newAngle) * (Math.PI / 180);
        this.x = mag * Math.cos(nonDumbAngleInRadians);
        this.y = mag * Math.sin(nonDumbAngleInRadians);
        this.roboAngle = this.x == 0.0 && this.y == 0.0 ? new Double(RCMath.normalizeDegrees(this.roboAngle + degrees)) : null;
    }

    public double getMagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void setMagnitude(double magnitude) {
        double mag = this.getMagnitude();
        if (mag > 0.0) {
            double adjustFactor = magnitude / this.getMagnitude();
            this.x *= adjustFactor;
            this.y *= adjustFactor;
        }
    }

    public double getRoboAngle() {
        if (this.roboAngle == null) {
            this.roboAngle = new Double(RCMath.getRobocodeAngle(this.x, this.y));
        }
        return this.roboAngle;
    }

    public Object clone() {
        return new VelocityVector(this.getRoboAngle(), this.getMagnitude());
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getInstance();
        return "(" + nf.format(this.x) + "," + nf.format(this.y) + "); mag: " + nf.format(this.getMagnitude()) + "; " + nf.format(this.getRoboAngle()) + " robocode degrees.";
    }
}

