/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import xander.core.Configuration;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.event.RoundBeginListener;
import xander.core.event.ScannedRobotListener;
import xander.core.event.SurvivalListener;
import xander.core.event.TurnListener;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;

public class SnapshotHistory
implements TurnListener,
RoundBeginListener,
ScannedRobotListener,
SurvivalListener {
    private Map<String, List<Snapshot>> snapshots = new HashMap<String, List<Snapshot>>();
    private Map<String, Snapshot> lastScanMap = new HashMap<String, Snapshot>();
    private Map<String, Boolean> aliveMap = new HashMap<String, Boolean>();
    private Snapshot lastOpponentScanned;
    private int historySize;
    private String myRobotName;
    private RobotProxy robotProxy;

    public SnapshotHistory(String myRobotName, RobotProxy robotProxy, Configuration configuration, RobotEvents robotEvents) {
        this.myRobotName = myRobotName;
        this.robotProxy = robotProxy;
        this.historySize = configuration.getSnapshotHistorySize();
        robotEvents.addTurnListener(this);
        robotEvents.addScannedRobotListener(this);
        robotEvents.addRoundBeginListener(this);
        robotEvents.addSurvivalListener(this);
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getOpponentCount() {
        return this.aliveMap.size() - 1;
    }

    public Snapshot getMySnapshot(long time, boolean allowGuess) {
        return this.getSnapshot(this.myRobotName, time, allowGuess);
    }

    public Snapshot getMySnapshot() {
        return this.getSnapshot(this.myRobotName);
    }

    public Iterator<Snapshot> getSnapshotIterator(String robotName, Snapshot startingSnapshot) {
        List<Snapshot> snapsForRobot = this.snapshots.get(robotName);
        Iterator<Snapshot> iter = null;
        if (snapsForRobot != null && snapsForRobot.size() > 0) {
            int idx = 0;
            if (startingSnapshot != null && (idx = snapsForRobot.indexOf(startingSnapshot)) < 0) {
                return null;
            }
            if (idx >= 0) {
                iter = snapsForRobot.iterator();
                int i = 0;
                while (i < idx) {
                    iter.next();
                    ++i;
                }
            }
        }
        return iter;
    }

    public Snapshot getSnapshot(String robotName) {
        Snapshot snapshot = null;
        List<Snapshot> snapsForRobot = this.snapshots.get(robotName);
        if (snapsForRobot != null && snapsForRobot.size() > 0) {
            snapshot = snapsForRobot.get(snapsForRobot.size() - 1);
        }
        return snapshot;
    }

    public Snapshot getEarliestSnapshot(String robotName) {
        Snapshot snapshot = null;
        List<Snapshot> snapsForRobot = this.snapshots.get(robotName);
        if (snapsForRobot != null && snapsForRobot.size() > 0) {
            snapshot = snapsForRobot.get(0);
        }
        return snapshot;
    }

    public Snapshot getPreviousSnapshot(Snapshot snapshot) {
        int idx;
        Snapshot previous = null;
        List<Snapshot> snapsForRobot = this.snapshots.get(snapshot.getName());
        if (snapsForRobot != null && snapsForRobot.size() > 0 && (idx = snapsForRobot.indexOf(snapshot)) > 0) {
            previous = snapsForRobot.get(--idx);
        }
        return previous;
    }

    public Snapshot getSnapshot(String robotName, long time, boolean allowGuess) {
        List<Snapshot> snapsForRobot = this.snapshots.get(robotName);
        if (snapsForRobot != null) {
            int i = snapsForRobot.size() - 1;
            while (i >= 0) {
                Snapshot snapshot = snapsForRobot.get(i);
                if (snapshot.getTime() == time) {
                    return snapshot;
                }
                if (snapshot.getTime() < time) {
                    if (allowGuess) {
                        long ticksToAdvance = time - snapshot.getTime();
                        long t = 0L;
                        while (t < ticksToAdvance) {
                            snapshot = snapshot.advance();
                            ++t;
                        }
                        return snapshot;
                    }
                    return null;
                }
                --i;
            }
        }
        return allowGuess ? new Snapshot(robotName, 400.0, 300.0, 0.0, 0.0, 100.0, 100.0, time) : null;
    }

    public Boolean isAlive(String robotName) {
        return this.aliveMap.get(robotName);
    }

    public Snapshot getLastOpponentScanned() {
        return this.lastOpponentScanned;
    }

    public Collection<Snapshot> getLastOpponentsScanned() {
        return Collections.unmodifiableCollection(this.lastScanMap.values());
    }

    private void addSnapshot(Snapshot snapshot) {
        List<Snapshot> snaps = this.snapshots.get(snapshot.getName());
        if (snaps == null) {
            snaps = new ArrayList<Snapshot>();
            this.snapshots.put(snapshot.getName(), snaps);
        }
        snaps.add(snapshot);
        if (snaps.size() > this.historySize) {
            snaps.remove(0);
        }
        if (!this.aliveMap.containsKey(snapshot.getName())) {
            this.aliveMap.put(snapshot.getName(), Boolean.TRUE);
        }
        this.lastScanMap.put(snapshot.getName(), snapshot);
    }

    public void addGroupSnapshot(Snapshot snapshot) {
        this.addSnapshot(snapshot);
    }

    @Override
    public void onTurnBegin() {
        Snapshot mySnapshot = new Snapshot(this.robotProxy, 0.0);
        this.addSnapshot(mySnapshot);
    }

    @Override
    public void onTurnEnd() {
    }

    @Override
    public void onRoundBegin() {
        this.lastOpponentScanned = null;
        for (List<Snapshot> snaps : this.snapshots.values()) {
            snaps.clear();
        }
        this.lastScanMap.clear();
        for (String robotName : this.aliveMap.keySet()) {
            this.aliveMap.put(robotName, Boolean.TRUE);
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        Point2D.Double pos = RCMath.getRobotPosition(event.getBearingRadians(), event.getDistance(), this.robotProxy.getX(), this.robotProxy.getY(), this.robotProxy.getHeadingRadians());
        Snapshot snapshot = new Snapshot(event.getName(), pos.x, pos.y, event.getHeadingRadians(), event.getVelocity(), event.getDistance(), event.getEnergy(), event.getTime());
        this.addSnapshot(snapshot);
        this.lastOpponentScanned = snapshot;
    }

    @Override
    public void onWin(WinEvent event) {
    }

    @Override
    public void onDeath(DeathEvent event) {
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
        if (this.aliveMap.containsKey(event.getName())) {
            this.aliveMap.put(event.getName(), Boolean.FALSE);
        }
    }
}

