/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.event.KeyEvent;
import pedersen.core.Combatant;
import pedersen.core.Controller;
import pedersen.core.GameState;
import pedersen.core.Instructions;
import pedersen.core.Teammate;
import pedersen.debug.Console;
import pedersen.debug.Metrics;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.BulletBank;
import pedersen.divination.CombatWave;
import pedersen.divination.CombatWaveBank;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.HasPosition;
import pedersen.physics.SnapshotImpl;
import pedersen.physics.constant.VehicleImpl;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.ScannerSubsystem;
import pedersen.systems.TurretSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.team.communication.CommuniqueCancelBulletWave;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class EventProcessor {
    private static long countBulletHitEvent = 0L;
    private static long countBulletHitBulletEvent = 0L;
    private static long countBulletMissedEvent = 0L;
    private static long countHitByBulletEvent = 0L;
    private static long countHitRobotEvent = 0L;
    private static long countHitWallEvent = 0L;
    private static long countRobotDeathEvent = 0L;
    private static long countScannedRobotEvent = 0L;
    private static long countSkippedTurnEvent = 0L;
    private static long countWinEvent = 0L;
    private static long countDeathEvent = 0L;
    private static double totalDamageSustainedFromHittingWalls = 0.0;
    private static double totalDamageSustainedFromHittingRobots = 0.0;
    private static final boolean debug = false;

    public static void process(WinEvent e) {
        EventProcessor.log((Event)e);
        ++countWinEvent;
        Controller.getInstance().onWin();
    }

    public static void process(DeathEvent e) {
        EventProcessor.log((Event)e);
        ++countDeathEvent;
        Controller.getInstance().onDeath();
    }

    public static void process(SkippedTurnEvent e) {
        EventProcessor.log((Event)e);
        ++countSkippedTurnEvent;
    }

    public static void process(BulletHitEvent e) {
        EventProcessor.log((Event)e);
        ++countBulletHitEvent;
        Bullet myBullet = e.getBullet();
        EventProcessor.removeMyBulletFromPlay(EventProcessor.getTime(), myBullet);
        Metrics.getInstance().bulletHitTarget(myBullet.getPower());
        TargetBank.getInstance().onRobotHitByCombatant(e.getName(), myBullet.getPower());
        NotificationSubsystem.getInstance().publishWaveCountChange();
    }

    public static void process(BulletHitBulletEvent e) {
        EventProcessor.log((Event)e);
        ++countBulletHitBulletEvent;
        EventProcessor.removeMyBulletFromPlay(EventProcessor.getTime(), e.getBullet());
        EventProcessor.removeBulletFromPlay(EventProcessor.getTime(), e.getHitBullet(), true);
        NotificationSubsystem.getInstance().publishWaveCountChange();
    }

    public static void process(HitByBulletEvent e) {
        ++countHitByBulletEvent;
        String name = e.getName();
        Bullet notMyBullet = e.getBullet();
        Metrics.getInstance().bulletHitCombatant(notMyBullet.getPower());
        TargetBank.getInstance().onCombatantHitByRobot(name, notMyBullet.getPower());
        CombatWave wave = EventProcessor.removeBulletFromPlay(EventProcessor.getTime(), notMyBullet, false);
        if (wave != null) {
            NotificationSubsystem.getInstance().publishHitByBullet(wave);
        }
        NotificationSubsystem.getInstance().publishWaveCountChange();
    }

    public static void process(BulletMissedEvent e) {
        EventProcessor.log((Event)e);
        ++countBulletMissedEvent;
        EventProcessor.removeMyBulletFromPlay(EventProcessor.getTime(), e.getBullet());
    }

    public static void process(HitRobotEvent e) {
        ++countHitRobotEvent;
        e.getBearingRadians();
        e.getEnergy();
        e.getName();
        TargetBank.getInstance().onRobotCollision(e.getName());
        totalDamageSustainedFromHittingRobots += 0.6;
    }

    public static void process(HitWallEvent e) {
        EventProcessor.log((Event)e);
        ++countHitWallEvent;
        double velocityAtTimeOfImpact = Instructions.getInstance().getChassisFuturePosition().getVelocity().velocity();
        double damageSustainedFromImpact = Rules.getWallHitDamage((double)velocityAtTimeOfImpact);
        totalDamageSustainedFromHittingWalls += damageSustainedFromImpact;
    }

    public static void process(RobotDeathEvent e) {
        Target target;
        EventProcessor.log((Event)e);
        ++countRobotDeathEvent;
        String name = e.getName();
        Teammate teammate = Teammate.findByName(name);
        if (teammate != null) {
            teammate.deactivate();
        }
        if ((target = TargetBank.getInstance().findByName(name)) != null) {
            target.deactivate();
            TurretSubsystem.getInstance().onRobotDeath(target);
            ScannerSubsystem.getInstance().onRobotDeath(target);
            Combatant.getCombatant().onRobotDeath(target);
        }
    }

    public static void process(ScannedRobotEvent e) {
        ++countScannedRobotEvent;
        VehicleImpl chassis = new VehicleImpl((HasPosition)GameState.getInstance().getRelativePosition(e.getBearingRadians(), e.getDistance()), e.getHeadingRadians(), e.getVelocity());
        SnapshotImpl snapshot = new SnapshotImpl(GameState.getInstance().getRound(), e.getTime(), chassis, e.getEnergy());
        Controller.getInstance().processRobotSnapshot(e.getTime(), e.getName(), snapshot, true);
    }

    public static void process(MessageEvent e) {
        CommunicationSubsystem.getInstance().process(e);
    }

    public static void process(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == 'c') {
            CommunicationSubsystem.debug = !CommunicationSubsystem.debug;
            EventProcessor.consoleTick("CommunicationSubsystem.debug: " + CommunicationSubsystem.debug);
        } else if (key == 'w') {
            GraphicalDebugger.paintCombatWaveBank = !GraphicalDebugger.paintCombatWaveBank;
        } else if (key == 'v') {
            GraphicalDebugger.paintFiringSolutions = !GraphicalDebugger.paintFiringSolutions;
        } else if (key == 'b') {
            GraphicalDebugger.paintBins = !GraphicalDebugger.paintBins;
        } else if (key == 'm') {
            GraphicalDebugger.paintMovementMethods = !GraphicalDebugger.paintMovementMethods;
        } else if (key == 's') {
            GraphicalDebugger.paintScannerSubsystem = !GraphicalDebugger.paintScannerSubsystem;
        } else if (key == 't') {
            GraphicalDebugger.paintTurretSubsystem = !GraphicalDebugger.paintTurretSubsystem;
        } else if (key == 'o') {
            GraphicalDebugger.paintOpponents = !GraphicalDebugger.paintOpponents;
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Unsupported key pressed: ").append(e.getKeyChar());
            buffer.append("\nSupported Debugging Toggles:");
            buffer.append("\nc: communication subsystem");
            buffer.append("\nw: inbound, outbound, and teammate waves");
            buffer.append("\nv: virtual bullets");
            buffer.append("\nb: guess-factor gun bins");
            buffer.append("\nm: movement");
            buffer.append("\ns: scanner subsystem");
            buffer.append("\nt: turret subsystem");
            buffer.append("\no: opponents");
            EventProcessor.consoleTick(buffer.toString());
        }
    }

    public static void process(BattleEndedEvent e) {
        EventProcessor.log((Event)e);
        NotificationSubsystem.getInstance().publishOnGameOver();
    }

    private static CombatWave removeMyBulletFromPlay(long time, Bullet b) {
        CombatWave wave = BulletBank.getInstance().find(b);
        BulletBank.getInstance().remove(b);
        if (wave != null) {
            EventProcessor.communicateWaveCancellation(wave, b);
        } else {
            EventProcessor.consoleTick("Failed to find my bullet in the list of bullets I've fired.  Not good.");
        }
        return wave;
    }

    private static CombatWave removeBulletFromPlay(long time, Bullet b, boolean intercept) {
        CombatWave wave = CombatWaveBank.getInstance().findInboundWaveByBullet(time, b);
        if (wave != null) {
            EventProcessor.communicateWaveCancellation(wave, b);
        }
        return wave;
    }

    private static void communicateWaveCancellation(CombatWave wave, Bullet bullet) {
        CommuniqueCancelBulletWave bx = new CommuniqueCancelBulletWave(wave.getTimeOfCreation(), wave.getPosition().getX(), wave.getPosition().getY(), bullet.getHeadingRadians(), wave.getVelocity().velocity());
        CommunicationSubsystem.getInstance().prepareCommunique(bx);
    }

    public static String getStats() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" - Event Statistics - ");
        buffer.append("\n").append("countBulletHitEvent = ").append(countBulletHitEvent);
        buffer.append("\n").append("countBulletHitBulletEvent = ").append(countBulletHitBulletEvent);
        buffer.append("\n").append("countBulletMissedEvent = ").append(countBulletMissedEvent);
        buffer.append("\n").append("countHitByBulletEvent = ").append(countHitByBulletEvent);
        buffer.append("\n").append("countHitRobotEvent = ").append(countHitRobotEvent);
        buffer.append("\n").append("countHitWallEvent = ").append(countHitWallEvent);
        buffer.append("\n").append("countRobotDeathEvent = ").append(countRobotDeathEvent);
        buffer.append("\n").append("countScannedRobotEvent = ").append(countScannedRobotEvent);
        buffer.append("\n").append("countSkippedTurnEvent = ").append(countSkippedTurnEvent);
        buffer.append("\n").append("Bullet hit/miss ratio: ").append(100.0 * (double)countBulletHitEvent / (double)(countBulletHitEvent + countBulletMissedEvent)).append("%");
        buffer.append("\n").append("Bullet intercept ratio: ").append(100.0 * (double)countBulletHitBulletEvent / (double)(countBulletHitEvent + countBulletMissedEvent + countBulletHitBulletEvent)).append("%");
        buffer.append("\n").append("totalDamageSustainedFromHittingWalls = ").append(totalDamageSustainedFromHittingWalls);
        buffer.append("\n").append("totalDamageSustainedFromHittingRobots = ").append(totalDamageSustainedFromHittingRobots);
        return buffer.toString();
    }

    private static void log(Event e) {
    }

    private static long getTime() {
        return GameState.getInstance().getTurn();
    }

    private static void consoleTick(String condition) {
        Console.getInstance().tick(condition);
    }
}

